
const { ccclass, property } = cc._decorator;

/**
 * 自动引用被@property 装饰的属性
 * 要求变量名与节点名相同，数组的节点名比变量名多了下划线和索引
 */
@ccclass
export default class ResetComponent extends cc.Component {
    @property(cc.Label)
    public textLbl: cc.Label = null;
    @property(cc.Button)
    public okBtn: cc.Button = null;
    @property(cc.Label)
    public okLbl: cc.Label = null;
    @property([cc.Label])
    public textLbls: cc.Label[] = [];

    onLoad() {
        if (CC_EDITOR) {
            this.resetInEditor();
        }
    }

    public resetInEditor() {
        let Attr = (<any>cc.Class).Attr
        let cClass = cc.js.getClassByName(cc.js.getClassName(this));
        let attrs = Attr.getClassAttrsProto(cClass);
        let DELIMETER = Attr.DELIMETER;
        for (const key in this) {
            let visible = attrs[key + DELIMETER + "visible"];
            if (key[0] === '_' || visible === false) continue;
            //感谢Jare技术支持
            let ctor = attrs[key + DELIMETER + "ctor"];
            let defaultValue = attrs[key + DELIMETER + "default"];
            if (this.hasOwnProperty(key) && ctor) {
                //自动查找引用
                if (defaultValue && Array.isArray(defaultValue)) {  //数组
                    this[key] = <any>[];        //重置
                    for (let i: number = 0; ; i++) {
                        let node: cc.Node = this.findChild(key + "_" + i, this.node);
                        //数组某一个找不到就不再找了
                        if (!node) {
                            break;
                        }
                        this.setProto(key, node, ctor, i);
                    }
                }
                else {
                    let node: cc.Node = this.findChild(key, this.node);
                    this.setProto(key, node, ctor);
                }
            }
        }
    }

    private setProto(key: string, node: cc.Node, ctor: any, arrayIndex: number = -1) {
        let value = undefined;
        if (node) {
            value = ctor == cc.Node ? node : node.getComponent(ctor);
        }
        if (value) {
            if (arrayIndex > -1) {
                this[key][arrayIndex] = value;
            }
            else {
                this[key] = value;
            }
        }
    }


    /** 递归查找孩子节点 */
    private findChild(name: string, parent: cc.Node): cc.Node {
        let child: cc.Node = parent.getChildByName(name);
        if (child) {
            return child;
        } else {
            let children: cc.Node[] = parent.children;
            for (let i = 0; i < children.length; i++) {
                child = this.findChild(name, children[i]);
                if (child) {
                    return child;
                }
            }
        }
        return null;
    }
}
