
const { ccclass, property } = cc._decorator;

@ccclass
export default class test extends cc.Component {

    @property(cc.Node)
    actionNode: cc.Node = null;

    @property(cc.Button)
    actionButton: cc.Button = null;

    @property(cc.Button)
    actionAudioButton: cc.Button = null;

    private _initPos: cc.Vec2;

    start() {
        cc.loader.loadRes("bomb", cc.AudioClip);
        
        this._initPos = this.actionNode.getPosition().clone();
        let action = cc.sequence(
            cc.moveBy(.2, cc.v2(500, 0)),
            cc.moveTo(.2, this._initPos),
        );
        this.actionButton.node.on("click", () => {
            this.actionNode.runAction(action);
        });

        this.actionAudioButton.node.on("click", () => {
            this.actionNode.runAction(action);
            cc.loader.loadRes("bomb", cc.AudioClip, function (err: Error, clip: cc.AudioClip) {
                if (!err) {
                    cc.audioEngine.playEffect(clip, false);
                } else {
                    console.warn(JSON.stringify(err));
                }
            });
        });
    }
}
