cc.Class({
    extends: cc.Component,

    properties: {
        _pressed: false,
    },


    onLoad: function () {

    },

    onEnable: function () {
        this._pressed = false;
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);

    },

    onDisable: function () {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
    },


    _onTouchBegan: function (e) {
        this._pressed = true;
        e.stopPropagation();
    },

    _onTouchMove: function (e) {
        if (this._pressed) {
            var p2 = e.getDelta();
            if (p2.x !== 0 || p2.y !== 0) {
                var p1 = this.node.getPosition();
                var p = cc.pAdd(p1, p2);
                this.node.setPosition(p);
                zz.log('position', p.x, p.y);
            }
        }
        e.stopPropagation();
    },

    _onTouchEnded: function (e) {
        this._pressed = false;
        e.stopPropagation();
    },

    _onTouchCancel: function (e) {
        this._pressed = false;
        e.stopPropagation();
    },


});
