
import platform, { CONST_PLATFORM_NAME } from "./Platform";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Main extends cc.Component {
   
    onLoad() {
        this.runGame();
    }

    private async runGame() {
        const self = this;
        if (platform.getPlatFormName() === CONST_PLATFORM_NAME.WX) {

            const systemInfo = wx.getSystemInfoSync();
            console.log(systemInfo);

            // 查看是否授权
            wx.getSetting({
                success(res) {
                    if (res.authSetting['scope.userInfo']) {
                        // 已经授权，可以直接调用 getUserInfo 获取头像昵称
                        wx.getUserInfo({
                            success: function (res) {
                                console.log('getUserInfo', res.userInfo)

                                const userInfo = res.userInfo;
                                platform.playerInfo.name = userInfo.nickName;
                                platform.playerInfo.headUrl = userInfo.avatarUrl;
                                platform.playerInfo.gender = userInfo.gender; //性别 0：未知、1：男、2：女

                                self.getDataAsync();
                            }
                        })
                    } else {
                        let button_top = systemInfo.windowHeight * 0.4; //0;
                        let button_width = 400;
                        try {
                            // console.log('getSystemInfoSync', res)
                            const safeArea = systemInfo.safeArea;
                            button_width = systemInfo.windowWidth;
                            button_top = safeArea.top + safeArea.height * 0.62 - systemInfo.statusBarHeight;
                        } catch (e) {
                            // Do something when catch error
                        }

                        const button = wx.createUserInfoButton({
                            type: 'text',
                            text: '进入游戏',
                            style: {
                                left: 0,
                                top: button_top,
                                width: button_width,
                                height: 50,
                                lineHeight: 50,
                                backgroundColor: '#90ef62',
                                color: '#ffffff',
                                textAlign: 'center',
                                fontSize: 20,
                                borderRadius: 5
                            }
                        })
                        button.onTap((res) => {
                            // console.log('button.onTap createUserInfoButton ', res)
                            const userInfo = res.userInfo;
                            if (res && res.userInfo) {
                                platform.playerInfo.name = userInfo.nickName;
                                platform.playerInfo.headUrl = userInfo.avatarUrl;
                                platform.playerInfo.gender = userInfo.gender; //性别 0：未知、1：男、2：女
                                self.getDataAsync();
                                button.hide();
                            }
                        })
                    }
                }
            })
        } else {
            this.getDataAsync();
        }
    }

    private async getDataAsync() {
        await platform.getDataAsync().then(() => {
           //进入游戏
        }, (err) => {
           
        });
    }
}
