

class Platform {

    constructor() {
    }
    private _name: string;
    public getPlatFormName() {
        if (!this._name) {
            if (typeof FBInstant !== 'undefined') {
                this._name = CONST_PLATFORM_NAME.FB;
            } else if (CC_WECHATGAME) {
                this._name = CONST_PLATFORM_NAME.WX;
            }
            else {
                if (CC_DEBUG) {
                    this._name = CONST_PLATFORM_NAME.DEBUG;
                } else {
                    this._name = CONST_PLATFORM_NAME.RELEASE;
                }
            }
        }
        return this._name;
    }

    
    userData = {};
    playerInfo: {
        playerID: string | number,
        name: string,
        headUrl: string,
        gender: number
    }
        = { playerID: 0, name: '', headUrl: '', gender: 0 }
    //获取数据，调用一次
    getDataAsync() {
        return new Promise((resolve, reject) => {
            switch (this.getPlatFormName()) {
                
                case CONST_PLATFORM_NAME.WX: {
                    wx.cloud.init({
                        env: 'firing-balls' //填写你自己的环境
                    })
                    wx.showShareMenu({});
                    // console.log(`wx.cloud`, wx.cloud)
                    wx.cloud.callFunction({
                        // 云函数名称
                        name: 'user',
                        // 传给云函数的参数
                        data: {
                            func: 'getUser',
                            data: {},
                        },
                    }).then((res) => {
                        console.log('getDataAsync success', res);
                        const result = res.result || {};
                        console.log('result', result);

                        for (const key in result || {}) {
                            if (result.hasOwnProperty(key)) {
                                this.userData[key] = result[key];
                            }
                        };
                        this.playerInfo.playerID = result['_id'] || this.playerInfo.playerID;
                        resolve();
                    }, (err) => {
                        console.log('getDataAsync err', err)
                        reject(err);
                    })
                    // console.log(`resolve`, CONST_PLATFORM_NAME.WX)

                    break;
                }
                default: {
                    this.playerInfo.name = 'lucky';
         
                    resolve();
                }
            }
        })
    }

    //刷新数据上传
    flushDataAsync() {
        return new Promise((resolve, reject) => {
            switch (this.getPlatFormName()) {
             
                case CONST_PLATFORM_NAME.WX: {
                    const userData = this.userData;
                    console.log(`flushDataAsync`, userData)
                    wx.cloud.callFunction({
                        // 云函数名称
                        name: 'user',
                        // 传给云函数的参数
                        data: {
                            func: 'addUser',
                            data: userData,
                        },
                    }).then(res => {
                        console.log('flushDataAsync success', res)
                        // console.log(res.result)
                        resolve();

                    }, (err) => {
                        console.log('flushDataAsync err', err)
                        reject();
                    })
                }
                default: {
                    resolve()
                }
            }
        })
    }

   //上传分数
    uploadScore(score: number) {
        return new Promise((resolve, reject) => {
            switch (this.getPlatFormName()) {
                case CONST_PLATFORM_NAME.WX: {
                    wx.cloud.callFunction({
                        // 云函数名称
                        name: 'rank',
                        // 传给云函数的参数
                        data: {
                            func: 'uploadScore',
                            data: { score, playerInfo: this.playerInfo },
                        },
                    }).then((res) => {
                        console.log('uploadScore success', res);
                        resolve();
                    }, (err) => {
                        console.log('uploadScore err', err)
                        reject(err);
                    })
                    break;
                }
                default: {
                    
                    resolve()
                }
            }
        })
    }

    //获取排行榜
    getScoreRankInfo(count = 10, offset = 0) {
        const outDatas: { rank: number, score: number, extraData: string, name: string, headUrl: string, id?: number | string }[] = [];
        return new Promise((resolve, reject) => {
            switch (this.getPlatFormName()) {
                case CONST_PLATFORM_NAME.WX: {
                        wx.cloud.callFunction({
                            // 云函数名称
                            name: 'rank',
                            // 传给云函数的参数
                            data: {
                                func: 'getScoreRankInfo',
                                data: { count, offset },
                            },
                        }).then((res) => {
                            console.log('getScoreRankInfo success', res);
                            const result = res.result || [];
                            // console.log('result', result);
                            for (const entry of result) {
                                const outData = { rank: -1, score: 0, extraData: '', name: '', headUrl: '', id: '' };
                                const playerInfo = entry.playerInfo;
                                outData.score = entry.score;
                                outData.rank = ++offset;//entry.getRank();
                                outData.id = playerInfo.playerID;

                                outData.name = playerInfo.name;
                                outData.headUrl = playerInfo.headUrl;
                                outDatas.push(outData);
                            };
                            resolve(outDatas);
                        }, (err) => {
                            console.log('getDataAsync err', err)
                            reject(err);
                        })
                    break;
                }
                default: {
                    //todo
                    const debug_names = ['Felix', 'Aaron', 'Astrid Fowler', 'Vincent', 'Christine', 'Theodore Palmer', 'Phoebe', 'Belinda', 'Edmund', 'Elaine', 'Jean', 'Martina', 'Joyce', 'Egbert', 'Duke', 'Merlin', 'Josephine', 'Leif', 'Joyce', 'Rose', 'Pandora', 'Jared', 'Zora', 'Eric', 'Martin', 'Jeffrey', 'Jane', 'Barnett', 'Queena', 'Susie', 'Andy'];
                    for (let index = offset + 1; index <= count; index++) {
                        outDatas.push({
                            rank: index, score: (outDatas[outDatas.length - 1] || { score: 9999 + Math.round(9999 * Math.random()) }).score - Math.round(999 * Math.random()),
                            extraData: ``, name: `${debug_names[index % debug_names.length]}`, headUrl: ''
                        });
                    };
                    resolve(outDatas);
                }
            }
        })
    }
}

const platform = new Platform();
export default platform;
export const CONST_PLATFORM_NAME = {
    FB: 'FB',
    DEBUG: 'DEBUG',
    RELEASE: 'RELEASE',
    WX: 'WX'
}


