const app = require('wx-server-sdk')

app.init();
const db = app.database();
const collection = db.collection('rank');

const uploadScore = async (_openid, userInfo) => {
  const id = userInfo._id;
  delete userInfo._id;
  userInfo._serverDate = db.serverDate();
  await collection.doc(_openid).set({ data: userInfo });
  userInfo._id = id;
  return userInfo;
}

const getMyRankInfo = async (_openid, data) => {
  let user;
  const hasUser = await collection.where({ _id: _openid }).get();
  if (Array.isArray(hasUser.data) && hasUser.data.length === 0) {
    user = {score:0,rank:0};
  } else {
    const user_t = await collection.doc(_openid).get();
    user = user_t.data;
  }
  return user;
}

const getScoreRankInfo = async (_openid, data) => {
  const all_data = await collection.orderBy('score', 'desc')
    .skip(data.offset) //  
    .limit(data.count) //  
    .get();
  const all_data_data = all_data.data;
  return all_data_data;
}


exports.main = async (event, context) => {
  const { func, data } = event;
  const { OPENID, APPID, UNIONID } = app.getWXContext();
  let res;
  if (func === 'uploadScore') {
    res = await uploadScore(OPENID, data);
  } else if (func === 'getMyRankInfo') {
    res = await getMyRankInfo(OPENID, data);
  } else if (func === 'getScoreRankInfo') {
    res = await getScoreRankInfo(OPENID, data);
  }

  return res;
}