let HotFixData = require("HotFixData");
let HotUpdate = require("HotUpdate");
cc.Class({
    extends: cc.Component,

    properties: {
        // 出包时生成的project.manifest文件
        manifestUrl: {
            type: cc.Asset,
            default: null,
        },
        commonSpriteAtlas: {
            type: cc.SpriteAtlas,
            default: null,
        },
        configJson: {
            type: cc.JsonAsset,
            default: null,
        },
        _loadNetCount: 0,
    },

    onLoad() {
        let GameApp = this.node.addComponent("GameApp");
        HotFixData.init();
        this.updateinfoLable = cc.find("layer_lb_updateinfo", this.node).getComponent(cc.Label);
        this.progressBarInfo = cc.find("layer_lb_updateinfo/pb_updateProgressBar", this.node).getComponent(cc.ProgressBar);
        cc.find("layer_lb_updateinfo/pb_updateProgressBar", this.node).active = false;
        this.barThumb = cc.find("layer_lb_updateinfo/pb_updateProgressBar/bar/barThumb", this.node);
        this.tip = cc.find("lb_tips", this.node);
        this.tip.active = false;
        this.stepUpdateInfo = cc.find("lb_update_info", this.node).getComponent(cc.Label);
        this.stepUpdateProgress = cc.find("lb_update_progress", this.node).getComponent(cc.Label);
    },
    start() {
        this._loadNetCount = 0;
        this.isRealy = false;
        if (cc.sys.os === cc.sys.OS_OSX && cc.sys.isNative) {
            this.isRealy = true;
        }
        this.stepinfo = "";
        if (cc.sys.isNative) {
            this.setCustomerRes();
        }
        this.startHotUpdate();
    },
    /**
     * 开始厅主模块热更
     */
    startHotUpdate() {
        this.stepinfo = "(1/2)开始更新";
        let self = this;
        if (cc.sys.isNative) {
            // 原生平台热更新
            HotUpdate.getInstance().goUpdate();
        }
    },

    update(dt) {
        if (this.updateinfoLable) {
            this.updateinfoLable.string = this.stepinfo;
        }
        if (this.stepUpdateInfo && this.stepUpdateProgress) {
            this.stepUpdateInfo.string = HotFixData.info;
            this.stepUpdateProgress.string = HotFixData.fileProgress;
        }
        if (this.progressBarInfo) {
            this.progressBarInfo.progress = HotFixData.progress;
            if (this.barThumb) {
                if (this.progressBarInfo.progress === 0) {
                    this.barThumb.active = false;
                    cc.find("layer_lb_updateinfo/pb_updateProgressBar", this.node).active = false;
                } else {
                    this.barThumb.active = true;
                    cc.find("layer_lb_updateinfo/pb_updateProgressBar", this.node).active = true;
                }
                this.barThumb.x = this.progressBarInfo.progress * this.progressBarInfo.totalLength;
            }
        }
    },
    /**
     * 添加自定义配置场景
     */
    setCustomerRes() {
        cc.vv.ResourcesManager.loadResByPath("customer_res/texture/login/LoginBGP", (spData) => {
            let spbg = cc.find("sp_bg", this.node);
            if (spData && spData.isValid) {
                spbg.getComponent(cc.Sprite).spriteFrame = spData;
            }
        }, this, cc.SpriteFrame, false);

        cc.vv.ResourcesManager.loadResByPath("customer_res/texture/MasterLogo", (spData) => {
            let sp = cc.find("sp_loginLogo", this.node);
            if (spData && spData.isValid) {
                sp.getComponent(cc.Sprite).spriteFrame = spData;
            }
        }, this, cc.SpriteFrame, false);

        cc.vv.ResourcesManager.loadResByPath("customer_res/texture/login/LoginBG", (spData) => {
            if (spData && spData.isValid) {
                let spine = new cc.Node();
                let spbg2 = cc.find("sp_bg", this.node);
                spbg2.addChild(spine);
                let spineCom = spine.addComponent(sp.Skeleton);
                spineCom.premultipliedAlpha = true;
                spineCom.skeletonData = spData;
                spineCom.clearTrack(0);
                spineCom.setAnimation(1, "animation", true);
            }
        }, this, sp.SkeletonData, false);
    },

    onDestroy() {
        this.unscheduleAllCallbacks();
    },
});
