
import Global from "Global";
import { LogUtil, STAGES, TYPES } from "LogUtil";
import ResourcesManager from "ResourcesManager";

var _initFrameSize_ = cc.view._initFrameSize;
cc.view._initFrameSize = () => {
    _initFrameSize_.apply(cc.view, arguments);

    if (cc.view._isRotated && !cc.sys.isNative) {
        cc.game.container.style["-webkit-transform"] = "rotate(-90deg)";
        cc.game.container.style.transform = "rotate(-90deg)";
        setTimeout(() => {
            cc.game.container.style.margin = `${cc.view._frameSize.width}px 0px 0px`;
        });
        cc.view.convertToLocationInView = function (tx, ty, relatedPos) {
            var x = this._devicePixelRatio * (tx - relatedPos.left);
            var y = this._devicePixelRatio * (relatedPos.top + relatedPos.height - ty);
            return this._isRotated ? { x: y, y: cc.view._viewportRect.height - x } : { x, y };
        };
    } else if (!cc.view._isRotated && !cc.sys.isNative) {
        cc.view.convertToLocationInView = function (tx, ty, relatedPos) {
            var x = this._devicePixelRatio * (tx - relatedPos.left);
            var y = this._devicePixelRatio * (relatedPos.top + relatedPos.height - ty);
            return this._isRotated ? { x: this._viewportRect.width - y, y: x } : { x, y };
        };
    }
};

function initMgr() {
    cc.vv.ResourcesManager = new ResourcesManager();
}

function selectStageWithGameState(gameMode) {
    switch (gameMode) {
        case Global.GAME_MODE.Develop:
            return STAGES.DEV;
        case Global.GAME_MODE.QA:
            return STAGES.QA;
        case Global.GAME_MODE.Release:
            return STAGES.RELEASE;
        default:
            throw new Error(`GameApp: unknown Global.GAME_MOD: ${gameMode}`);
    }
}

function initLogUtil(gameMode) {
    const MAX_LOG_QUEUE_SIZE = 1000;
    const CLEAR_SIZE_PER_TIME = 200;
    const productStage = selectStageWithGameState(gameMode);
    cc.vv.LogUtil = new LogUtil(productStage, MAX_LOG_QUEUE_SIZE, CLEAR_SIZE_PER_TIME);
    if (cc.log) {
        cc.vv.LogUtil.addPipe((logStr, format, ...args) => {
            if (typeof format === "object") {
                // cc.log("[LogUtil][CCLOG]: ", format);
            } else {
                // cc.log("[LogUtil][CCLOG]: 省略字符串先不印出.");
            }
        });
    }
}

cc.Class({
    extends: cc.Component,

    properties: {
        gameMode: {
            default: Global.GAME_MODE.Develop,
            type: cc.Enum(Global.GAME_MODE),
        },
    },
    onLoad() {
        cc.vv = {};
        initLogUtil(this.gameMode);
        initMgr();
    },
});
