
function debugInit() {
    cc.game.setFrameRate(60);
    cc.debug.setDisplayStats(false);
    cc.log = console.log.bind(console);
    cc.logx = function () {
        var logStr = "";
        for (var i = 0; i < arguments.length; i++) {
            var arg = arguments[i];
            if (i > 0) {
                arg = " " + arg;
            }
            logStr += arg;
        }
        var error = new Error(logStr);
        cc.log(error.stack);
    }
    cc.sys.dump();
}

cc.Class({
    extends: cc.Component,

    properties: {
        imageNode: cc.Node,
        spineNode: cc.Node,
        editBox: cc.EditBox,
        btn: cc.Node,
    },

    onLoad: function () {
        debugInit();
        UIManager.init();
        ShaderManager.init();
        this.btn.on(cc.Node.EventType.TOUCH_END, this.onBtnClick, this);
    },

    onBtnClick: function () {
        if (!this.isAddShader) {
            this.isAddShader = true;
            ShaderManager.addShader(this.imageNode, "Gray");
            ShaderManager.addShader(this.spineNode, "Gray");
        }
        let grayLevel = this.editBox.string;
        grayLevel = Number(grayLevel);
        if (isNaN(grayLevel)) {
            grayLevel = 0;
        }
        cc.log("===灰化程度===", grayLevel);
        ShaderManager.setProperty(this.imageNode, "grayLevel", grayLevel);
        ShaderManager.setProperty(this.spineNode, "grayLevel", grayLevel);
    },
});
