//UI管理

window.UIManager = {};

let _uiRoot = null;

UIManager.init = function () {
    _uiRoot = cc.find("GameRoot");
    let viewSize = cc.view.getFrameSize();
    let viewWidth = viewSize.width;
    let vieWHeight = viewSize.height;
    let canvas = _uiRoot.getComponent(cc.Canvas);
    let designWidth = canvas.designResolution.width;
    let designHeight = canvas.designResolution.height;
    if ((viewWidth / vieWHeight) > (designWidth / designHeight)) {
        canvas.fitHeight = true;
        canvas.fitWidth = false;
    } else {
        canvas.fitHeight = false;
        canvas.fitWidth = true;
    }
    let widget = _uiRoot.getComponent(cc.Widget);
    if (widget) {
        widget.updateAlignment();
        widget.enabled = false;
    }
    _uiRoot.width = Math.ceil(_uiRoot.width);
    _uiRoot.height = Math.ceil(_uiRoot.height);
    window.VIEW_SIZE_W = viewWidth;
    window.VIEW_SIZE_H = vieWHeight;
    window.WIN_SIZE_W = _uiRoot.width;
    window.WIN_SIZE_H = _uiRoot.height;
}

UIManager.getUIRoot = function () {
    return _uiRoot;
}
