//Shader组件

window.ShaderComponent = cc.Class({
    extends: cc.Component,

    ctor: function () {
        this.applyCmp = null;
        this.shaderObj = null;
        this.shaderMaterial = null;
    },

    onLoad: function () {
        this.applyCmp = this.getComponent(cc.Sprite) || this.getComponent(sp.Skeleton);
    },

    setShader: function (shaderName, ...args) {
        this.shaderObj = ShaderManager.getShaderByName(shaderName);
        let material = cc.MaterialVariant.create(this.shaderObj.material, this.applyCmp);
        this.applyCmp.setMaterial(0, material);
        this.shaderMaterial = this.applyCmp.getMaterial(0);
        if (this.applyCmp instanceof sp.Skeleton) {
            this.shaderMaterial.define("CC_USE_MODEL", true);
        }
        if (this.shaderObj.start) {
            this.shaderObj.start(this.node, this.shaderMaterial, ...args);
        }
    },

    removeShader: function () {
        let materialName = "2d-sprite";
        if (this.applyCmp instanceof sp.Skeleton) {
            materialName = "2d-spine";
        }
        let material = cc.MaterialVariant.createWithBuiltin(materialName, this.applyCmp);
        this.applyCmp.setMaterial(0, material);
        this.applyCmp._activateMaterial();
        this.applyCmp = null;
        this.shaderObj = null;
        this.shaderMaterial = null;
    },

    setProperty: function (name, value) {
        if (this.shaderMaterial) {
            this.shaderMaterial.setProperty(name, value);
        }
    },

    getApplyCmp: function () {
        return this.applyCmp;
    },

    update: function (dt) {
        if (this.shaderObj && this.shaderObj.update) {
            this.shaderObj.update(this.node, this.shaderMaterial, dt);
        }
    },
});