//Shader管理

window.ShaderManager = {};
window.ShaderType = {};

let _shaders = {};

ShaderManager.defineShader = function (shader) {
    _shaders[shader.name] = shader;
    ShaderType[shader.name] = shader.name;
}

ShaderManager.init = function () {
    for (const shaderName in _shaders) {
        ShaderManager.loadMaterial(shaderName);
    }
}

ShaderManager.loadMaterial = function (shaderName) {
    cc.loader.loadRes("shader/" + shaderName, cc.Material, function (err, asset) {
        if (err) {
            cc.log(err);
            return;
        }
        _shaders[shaderName].material = asset;
    });
}

ShaderManager.addShader = function (node, shaderName, ...args) {
    if (!_shaders[shaderName] || !_shaders[shaderName].material) {
        return;
    }
    let cmp = node.getComponent("ShaderComponent");
    if (!cmp) {
        cmp = node.addComponent("ShaderComponent");
    }
    let applyCmp = cmp.getApplyCmp();
    if (!applyCmp) {
        node.removeComponent("ShaderComponent");
        return;
    }
    cmp.setShader(shaderName, ...args);
}

ShaderManager.removeShader = function (node) {
    let cmp = node.getComponent("ShaderComponent");
    if (!cmp || !cc.isValid(cmp, true)) {
        return;
    }
    let applyCmp = cmp.getApplyCmp();
    if (!applyCmp) {
        return;
    }
    cmp.removeShader();
    node.removeComponent("ShaderComponent");
}

ShaderManager.setProperty = function (node, name, value) {
    let cmp = node.getComponent("ShaderComponent");
    if (!cmp || !cc.isValid(cmp, true)) {
        return;
    }
    let applyCmp = cmp.getApplyCmp();
    if (!applyCmp) {
        return;
    }
    cmp.setProperty(name, value);
}

ShaderManager.getShaderByName = function (shaderName) {
    return _shaders[shaderName];
}
