// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html


const {ccclass, property} = cc._decorator;

@ccclass
export default class MainScene extends cc.Component {

    @property(cc.Node)
    hangNode: cc.Node = null;

    @property(cc.Label)
    tipLabel:cc.Label = null;

    url:string = 'http://192.168.0.200/webView3';

    callbackKey:string = 'closewebview';

    webView:cc.WebView = null;

    start () {
        cc['mainScene'] = this;
        if (CC_JSB) {
            this.tipLabel.string = '看到的是app';
        }else{
            this.tipLabel.string = '看到的是webView';
        }
    }
    openWebView(){
        if(!this.webView){
            this.webView = this.hangNode.addComponent(cc.WebView);
            if(CC_JSB){
                this.webView.url = this.url+'?isNative=1';
            }else{
                this.webView.url = this.url;
            }
            this.webView.setJavascriptInterfaceScheme(this.callbackKey);
            this.webView.setOnJSCallback(this.closeInApp.bind(this));
        }else{
            console.error('已有webView');
        }
    }
    closeInApp(){
        this.hangNode.removeComponent(this.webView);
        this.webView.destroy();
        this.webView = null;
        console.log('已关闭webView');
    }
    closeInWebView(){
        if(location.href.indexOf('isNative') !== -1){
            document.location = this.callbackKey+'://a=1&b=2';
        }else{
            parent.cc.mainScene.closeInApp();
        }
    }
    // update (dt) {}
}
