import Game from "./Game";

const {ccclass, property} = cc._decorator;

@ccclass
export default class Camera3D extends cc.Component {
    private initPosition: cc.Vec3 = cc.v3();
    private velocity: cc.Vec3 = cc.v3();
    position: cc.Vec3 = cc.v3();
    private prevPosition: cc.Vec3 = cc.v3();
    private stopMovement: boolean;
    private _tmpVec3: cc.Vec3 = cc.v3();
    private _tmpVec33: cc.Vec3 = cc.v3();
    private _smoothArg: {velocity: number, pos?: number} = {velocity: 0};

    onLoad() {
        this.node.getPosition(this.initPosition);
    }

    followToPlayer() {
        this.position.set(this.prevPosition);
        this.node.getPosition(this.prevPosition);
    }

    forceMove() {
        this.stopMovement = false;
        this.prevPosition.set(this.position);
        this._smoothArg.velocity = this.velocity.x;
        this.smoothDamp(this.node.x, this.position.x + this.initPosition.x, this._smoothArg, Game.GameCameraLerpSpeed);
        this.velocity.x = this._smoothArg.velocity;
        this._tmpVec3.x = this._smoothArg.pos;
        this._smoothArg.velocity = this.velocity.y;
        this.smoothDamp(this.node.y, this.position.y + this.initPosition.y, this._smoothArg, Game.GameCameraLerpSpeed);
        this.velocity.y = this._smoothArg.velocity;
        this._tmpVec3.y = this._smoothArg.pos;
        this._tmpVec3.z = this.node.z;
        this.node.setPosition(this._tmpVec3);
    }

    forcePosition(position: cc.Vec3) {
        this.node.setPosition(position.x + Game.CameraDefaultPosition.x, position.y + Game.CameraDefaultPosition.y, this.node.z);
    }

    stop() {
        this.stopMovement = true;
    }

    update() {
        Game.level.player.node.getPosition(this._tmpVec3);
        this._tmpVec3.lerp(cc.Vec3.ZERO, Game.GamePlayerRelativeCameraPosition, this.position); //this.position的z值有变化，但不会采用
        if (!this.stopMovement) {
            this._tmpVec3.x = this.position.x + this.initPosition.x;
            this._tmpVec3.y = this.position.y + this.initPosition.y;
            this._tmpVec3.z = this.node.z;
            if (!this.prevPosition.equals(this.position) || !this._tmpVec3.equals(this.node.getPosition(this._tmpVec33))) {
                this._smoothArg.velocity = this.velocity.x;
                this.smoothDamp(this.node.x, this._tmpVec3.x, this._smoothArg, Game.GameCameraLerpSpeed);
                this.velocity.x = this._smoothArg.velocity;
                this._tmpVec3.x = this._smoothArg.pos;
                this._smoothArg.velocity = this.velocity.y;
                this.smoothDamp(this.node.y, this._tmpVec3.y, this._smoothArg, Game.GameCameraLerpSpeed);
                this.velocity.y = this._smoothArg.velocity;
                this._tmpVec3.y = this._smoothArg.pos;
                this._tmpVec3.z = this.node.z;
                this.node.setPosition(this._tmpVec3);
                this.prevPosition.set(this.position);
            }
        }
    }

    // current: 当前的位置
    // target: 我们试图接近的位置
    // result: 当前速度和位置
    // smoothTime: 到达目标的大约时间，较小的值将快速到达目标
    // maxSpeed: 选择允许你限制的最大速度
    // deltaTime: 自上次调用这个函数的时间。默认为 Time.deltaTime
    private smoothDamp(current: number, target: number, result: {velocity: number, pos?: number}, smoothTime: number, maxSpeed = Number.POSITIVE_INFINITY, deltaTime = cc.director.getDeltaTime()) {
        smoothTime = Math.max(0.0001, smoothTime);
        let num1 = 2 / smoothTime;
        let num2 = num1 * deltaTime;
        let num3 = 1 / (1 + num2 + 0.479999989271164 * num2 * num2 + 0.234999999403954 * num2 * num2 * num2);
        let num4 = current - target;
        let num5 = target;
        let max = maxSpeed * smoothTime;
        let num6 = cc.misc.clampf(num4, -max, max);
        target = current - num6;
        let num7 = (result.velocity + num1 * num6) * deltaTime;
        result.velocity = (result.velocity - num1 * num7) * num3;
        result.pos = target + (num6 + num7) * num3;
        if (num5 - current > 0 == result.pos > num5) {
            result.pos = num5;
            result.velocity = (result.pos - num5) / deltaTime;
        }
    }
}