

const {ccclass, property} = cc._decorator;

@ccclass
export default class UpdateScene extends cc.Component {

    @property(cc.Node)
    updateNode : cc.Node = null

    @property(cc.Label)
    updateTips: cc.Label = null;
    
    @property(cc.Label)
    fileTipLabel: cc.Label = null;

    @property(cc.Label)
    byteTipLabel: cc.Label = null;

    @property(cc.ProgressBar)
    fileProgressBar: cc.ProgressBar = null;

    @property(cc.ProgressBar)
    byteProgressBar: cc.ProgressBar = null;

    @property({type:cc.RawAsset})
    manifestUrl: cc.RawAsset = null;

    socket: GameSocket = null;

    _assetMgr: any = null;
    _manifestUrl: any = null;
    _updating : boolean = false;
    _canRetry : boolean = false;

    _remoteVer : any = null;

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.tips = "";
        this.fileProgressBar.node.active = false;
        this.byteProgressBar.node.active = false;
        this._manifestUrl = this.manifestUrl;
    }


    start () {
        this.requestVersion();
    }

    get storagePath(){
        return ((cc.sys.isNative && jsb && jsb.fileUtils) ? jsb.fileUtils.getWritablePath() : '/') + UPDATE_PATH;
    }

    requestVersion(request: SocketRequest){


        var data = request.data;
        this._remoteVer = data;
        console.log(this._remoteVer);

       
// backPackVer         强更版本号
// backPackUrl         强更地址 
// version             1.0.1                                                      远程资源版本
// packageUrl          http://192.168.1.243:8000/igod/1.0.1/                      远程资源的本地缓存根路径
// remoteVersionUrl    http://192.168.1.243:8000/igod/1.0.1/version.manifest      远程版本文件的路径，用来判断服务器端是否有新版本的资源
// remoteManifestUrl   http://192.168.1.243:8000/igod/1.0.1/project.manifest      远程资源 Manifest 文件的路径，包含版本信息以及所有资源信息
//ps:
// 小版本更新，参数不变，更新资源放在相同目录下
// 大版本更新，修改版本号及更新目录
        
        this.startCheckUpdate();
    }

    clearHotUpdateCache(){
        cc.sys.localStorage.setItem(UPDATE_HOTUPDATE_URL, "");
        if (cc.sys.isNative && jsb && jsb.fileUtils) {
            // 清理热更新的储存路径
            let storagePath = this.storagePath;
            if (jsb.fileUtils.isDirectoryExist(storagePath)) {
                jsb.fileUtils.removeDirectory(storagePath)
            }
        }
    }


    /**
     * 开始检测对比资源文件更新信息
     *
     * @returns
     * @memberof UpdateScene
     */
    startCheckUpdate(){
        
        console.log(this.storagePath);
        if (!cc.sys.isNative || !jsb) {
            this.jumpLoginScene();
            return
        }

        this._assetMgr = new jsb.AssetsManager(this._manifestUrl, this.storagePath);
        if (cc.sys.os === cc.sys.OS_ANDROID) {
            //当并发任务太多时，一些Android设备可能会减慢下载过程。
            //该值可能不准确，请做更多的测试，找到最适合您的游戏。
            this._assetMgr.setMaxConcurrentTask(2);
        }
        
        if (this._assetMgr.getState() === jsb.AssetsManager.State.UNINITED) {
            // Resolve md5 url
            var url = this._manifestUrl.nativeUrl;
            if (cc.loader.md5Pipe) {
                url = cc.loader.md5Pipe.transformURL(url);
            }
            this._assetMgr.loadLocalManifest(url);
        }
        if (!this._assetMgr.getLocalManifest() || !this._assetMgr.getLocalManifest().isLoaded()) {
            this.tips = 'Failed to load local manifest ...';
            return;
        }
        this._assetMgr.setEventCallback(this.checkCb.bind(this));

        this._assetMgr.checkUpdate();
        this._updating = true;
  
    }


    /**
     * 开始热更新
     *
     * @memberof UpdateScene
     */
    startHotUpdate() {
        if (this._assetMgr && !this._updating) {
            this._assetMgr.setEventCallback(this.updateCb.bind(this));

            if (this._assetMgr.getState() === jsb.AssetsManager.State.UNINITED) {
                // Resolve md5 url
                var url = this._manifestUrl.nativeUrl;
                if (cc.loader.md5Pipe) {
                    url = cc.loader.md5Pipe.transformURL(url);
                }
                this._assetMgr.loadLocalManifest(url);
            }

            this._assetMgr.update();
            this._updating = true;
        }
    }


    /**
     * 检测更新回调
     *
     * @param {*} event
     * @memberof UpdateScene
     */
    checkCb(event) {
        console.log('Code: ' + event.getEventCode());
        switch (event.getEventCode())
        {
            case jsb.EventAssetsManager.NEW_VERSION_FOUND:{
                this.tips = '发现新版本，即将开始更新';
                this.tipFile = "";
                this.tipByte = "";
                this.progressFile = 0;
                this.progressByte = 0;
                this.fileProgressBar.node.active = true;
                this.byteProgressBar.node.active = true;
                this.startHotUpdate();
            }break;
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                this.tips = "本地版本信息获取失败，请重新安装，即将跳过更新";
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                this.tips = "远程版本信息获取失败, 请联系客服，即将跳过更新"
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                this.tips = "您已经是最新版本，，即将跳过更新";
            default:
                // 跳转登陆场景
                setTimeout(this.jumpLoginScene.bind(this), 2000);
                break;
        }
        
        this._assetMgr.setEventCallback(null);
        this._updating = false;
    }


    /**
     * 热更新回调
     *
     * @param {*} event
     * @memberof UpdateScene
     */
    updateCb(event) {
        var needRestart = false;
        var failed = false;
        switch (event.getEventCode())
        {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                this.tips = "本地版本信息获取失败，请重新安装，即将跳过更新";
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:
                this.progressByte = event.getPercent();
                this.progressFile = event.getPercentByFile();

                this.tipFile = event.getDownloadedFiles() + ' / ' + event.getTotalFiles();
                this.tipByte = event.getDownloadedBytes() + ' / ' + event.getTotalBytes();

                var msg = event.getMessage();
                if (msg) {
                    this.tips = '更新文件: ' + msg;
                    // console.log(event.getPercent()/100 + '% : ' + msg);
                }
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                this.tips = "远程版本信息获取失败, 请联系客服，即将跳过更新"
                failed = true;
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                this.tips = "您已经是最新版本，，即将跳过更新";
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                this.tips = '更新完成. ' + event.getMessage();
                needRestart = true;
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                this.tips = '更新失败. ' + event.getMessage();
                this._updating = false;
                this._canRetry = true;
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                this.tips = '更新错误： ' + event.getAssetId() + ', ' + event.getMessage();
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                this.tips = event.getMessage();
                break;
            default:
                break;
        }

        if (failed) {
            this._assetMgr.setEventCallback(null);
            this._updating = false;
        }

        if (needRestart) {
            this._assetMgr.setEventCallback(null);
            
            //记录当前大版本号
            cc.sys.localStorage.setItem(UPDATE_CUR_VER, this._remoteVer.version);

            // Prepend the manifest's search path
            var searchPaths = jsb.fileUtils.getSearchPaths();
            var newPaths = this._assetMgr.getLocalManifest().getSearchPaths();
            console.log(JSON.stringify(newPaths));
            Array.prototype.unshift.apply(searchPaths, newPaths);
            // This value will be retrieved and appended to the default search path during game startup,
            // please refer to samples/js-tests/main.js for detailed usage.
            // !!! Re-add the search paths in main.js is very important, otherwise, new scripts won't take effect.
            cc.sys.localStorage.setItem('HotUpdateSearchPaths', JSON.stringify(searchPaths));
            jsb.fileUtils.setSearchPaths(searchPaths);

            cc.audioEngine.stopAll();
            cc.game.restart();
        }
    }

    retry() {
        if (!this._updating && this._canRetry) {
            this._canRetry = false;
            
            this.tips = 'Retry failed Assets...';
            this._assetMgr.downloadFailedAssets();
        }
    }


    jumpLoginScene() {
        cc.director.loadScene("loginScene", () => {
            console.log("load loginScene complete");
        });
    }

    set progressFile(progress : number){
        if(this.fileProgressBar){
            this.fileProgressBar.progress = progress;
        }
    }

    set progressByte(progress : number){
        if(this.byteProgressBar){
            this.byteProgressBar.progress = progress;
        }
    }

    set tipFile(tip : string){
        if(this.fileTipLabel){
            this.fileTipLabel.string = "" + tip;
        }
    }

    set tipByte(tip : string){
        if(this.byteTipLabel){
            this.byteTipLabel.string = "" + tip;
        }
    }

    set tips(tip : string) {
        if(this.updateTips){
            this.updateTips.string = "" + tip;
        }
    }
}
