
const MAX_DIE_STATE = 3;

let Hero = cc.Class({
    extends: cc.Component,
    properties: {
        defaultBoneAsset: dragonBones.DragonBonesAsset,         //默认骨骼
        defaultBoneAtlas: dragonBones.DragonBonesAtlasAsset,    //默认骨骼纹理
    },

    onLoad () {
        this.DragonAnim = cc.find("DragonAnim", this.node);
        cc.error("初始化")
    },

    start () {

    },

    onEnable(){

    },

    playBoneAnim: function(animName, loop){
        let armatureDisplay = this.DragonAnim.getComponent(dragonBones.ArmatureDisplay);
        armatureDisplay.dragonAsset = this.defaultBoneAsset;
        armatureDisplay.dragonAtlasAsset = this.defaultBoneAtlas;
        this.setAnimAction(animName, loop);
    },

    //设置当前动画
    setAnimAction: function(curAnim="", loop=-1){
        let armatureDisplay = this.DragonAnim.getComponent(dragonBones.ArmatureDisplay);
        if (armatureDisplay.dragonAsset && armatureDisplay.dragonAtlasAsset) {
            armatureDisplay.armatureName = "armatureName";

            // armatureDisplay.on(dragonBones.EventObject.FRAME_EVENT, this.onAnimFrameEvent, this);
            armatureDisplay.on(dragonBones.EventObject.COMPLETE, this.onAnimCompleteEvent, this);

            armatureDisplay.playAnimation("stand", loop);
        }
        // cc.log("******************播放", this._heroName, curAnim)
    },

    setCompleteFunc:function(func){
        this._animCompleteCallback = func;
    },

    onAnimCompleteEvent: function () {
        this._animCompleteCallback();
    }
});

module.exports = Hero;