import tileMapComp from "./tileMapComp";

const {ccclass, property} = cc._decorator;

@ccclass
export default class playerMapNode extends cc.Component {

    @property(cc.Camera)
    cam:cc.Camera = null;

    @property(cc.Node)
    tileMapNode:cc.Node = null;

    private curPos :cc.Vec2 = null;
    private tileMapComp:tileMapComp = null;

    onLoad(){
        this.tileMapComp = this.tileMapNode.getComponent(tileMapComp);

        this.curPos = cc.v2(0, 0);
        var _pos = this.tileMapComp.gridPosToWorldPos(this.curPos);
        _pos = this.node.parent.convertToNodeSpaceAR(_pos);
        this.node.setPosition(_pos);
    }

    onClickMove(event, data){
        var nextPos:cc.Vec2 = cc.v2(0,0);
        nextPos.x = this.curPos.x;
        nextPos.y = this.curPos.y;
        switch(parseInt(data))
        {
            case 1:
                nextPos.y--;
            break;
            case 4:
                nextPos.y++;
            break;

            case 2:
                if(nextPos.x%2==0)
                {
                    nextPos.y--;
                    nextPos.x++;
                }
                else
                    nextPos.x++;
            break;
            case 3:
                if(nextPos.x%2==0)
                {
                    nextPos.x++;
                }
                else
                {
                    nextPos.x++;
                    nextPos.y++;
                }
            break;
            case 5:
                if(nextPos.x%2==0)
                {
                    nextPos.x--;
                }
                else
                {
                    nextPos.y++;
                    nextPos.x--;
                }
            break;
            case 6:
                if(nextPos.x%2==0)
                {
                    nextPos.x--;
                    nextPos.y--;
                }
                else
                    nextPos.x--;
            break;
        }
        var _pos = this.tileMapComp.gridPosToWorldPos(nextPos);
        if(_pos)
        {
            _pos = this.node.parent.convertToNodeSpaceAR(_pos);
            this.curPos = nextPos;
            this.node.setPosition(_pos);

            this.cam.node.setPosition(this.node.getPosition());
        }
    }

}
