const {ccclass, property} = cc._decorator;

@ccclass
export default class tileMapComp extends cc.Component {

    @property(cc.Camera)
    cam:cc.Camera = null;

    @property()
    showGridPos:boolean = false;

    @property(cc.TiledLayer)
    gridLayer:cc.TiledLayer = null;

    private gridLayerSize:cc.Size = null;

    onLoad(){
        this.node.on(cc.Node.EventType.TOUCH_MOVE,this.onTouchMove,this);
    }

    onTouchMove(event)
    {
        var delta = event.touch.getDelta();
        var newPos = this.cam.node.getPosition();
        newPos.x -= delta.x;
        newPos.y -= delta.y;
        this.cam.node.setPosition(newPos);
    }

    getGridLayerSize(){
        return this.gridLayerSize;
    }

    gridPosToWorldPos(gridPos){
        var _pos = this.gridLayer.getPositionAt(gridPos);
        _pos = this.gridLayer.node.convertToWorldSpaceAR(_pos);
        if(_pos.equals(cc.v2(0,0))) return null;
        _pos.x+=90;
        _pos.y+=20;

        var _label = new cc.Node;
        var clabel = _label.addComponent(cc.Label);
        clabel.string = gridPos.x + "," + gridPos.y;
        clabel.fontSize = 30;
        var pos = this.gridLayer.getPositionAt(gridPos.x, gridPos.y);
        _label.parent = this.gridLayer.node;
        pos.x+=30;
        pos.y+=30;
        _label.setPosition(pos);

        return _pos;
    }
}
