"use strict";
cc._RF.push(module, '55b124rK7FE5qGsm8ZR7dWV', 'tileMapComp');
// tileMapComp.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var tileMapComp = /** @class */ (function (_super) {
    __extends(tileMapComp, _super);
    function tileMapComp() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.cam = null;
        _this.showGridPos = false;
        _this.gridLayer = null;
        _this.gridLayerSize = null;
        return _this;
    }
    tileMapComp.prototype.onLoad = function () {
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    tileMapComp.prototype.onTouchMove = function (event) {
        var delta = event.touch.getDelta();
        var newPos = this.cam.node.getPosition();
        newPos.x -= delta.x;
        newPos.y -= delta.y;
        this.cam.node.setPosition(newPos);
    };
    tileMapComp.prototype.getGridLayerSize = function () {
        return this.gridLayerSize;
    };
    tileMapComp.prototype.gridPosToWorldPos = function (gridPos) {
        var _pos = this.gridLayer.getPositionAt(gridPos);
        _pos = this.gridLayer.node.convertToWorldSpaceAR(_pos);
        if (_pos.equals(cc.v2(0, 0)))
            return null;
        _pos.x += 90;
        _pos.y += 20;
        var _label = new cc.Node;
        var clabel = _label.addComponent(cc.Label);
        clabel.string = gridPos.x + "," + gridPos.y;
        clabel.fontSize = 30;
        var pos = this.gridLayer.getPositionAt(gridPos.x, gridPos.y);
        _label.parent = this.gridLayer.node;
        pos.x += 30;
        pos.y += 30;
        _label.setPosition(pos);
        return _pos;
    };
    __decorate([
        property(cc.Camera)
    ], tileMapComp.prototype, "cam", void 0);
    __decorate([
        property()
    ], tileMapComp.prototype, "showGridPos", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], tileMapComp.prototype, "gridLayer", void 0);
    tileMapComp = __decorate([
        ccclass
    ], tileMapComp);
    return tileMapComp;
}(cc.Component));
exports.default = tileMapComp;

cc._RF.pop();