(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/playerMapNode.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'ccf57ZgkjNDOYc1SX89Rj8J', 'playerMapNode', __filename);
// playerMapNode.ts

Object.defineProperty(exports, "__esModule", { value: true });
var tileMapComp_1 = require("./tileMapComp");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var playerMapNode = /** @class */ (function (_super) {
    __extends(playerMapNode, _super);
    function playerMapNode() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.cam = null;
        _this.tileMapNode = null;
        _this.curPos = null;
        _this.tileMapComp = null;
        return _this;
    }
    playerMapNode.prototype.onLoad = function () {
        this.tileMapComp = this.tileMapNode.getComponent(tileMapComp_1.default);
        this.curPos = cc.v2(0, 0);
        var _pos = this.tileMapComp.gridPosToWorldPos(this.curPos);
        _pos = this.node.parent.convertToNodeSpaceAR(_pos);
        this.node.setPosition(_pos);
    };
    playerMapNode.prototype.onClickMove = function (event, data) {
        var nextPos = cc.v2(0, 0);
        nextPos.x = this.curPos.x;
        nextPos.y = this.curPos.y;
        switch (parseInt(data)) {
            case 1:
                nextPos.y--;
                break;
            case 4:
                nextPos.y++;
                break;
            case 2:
                if (nextPos.x % 2 == 0) {
                    nextPos.y--;
                    nextPos.x++;
                }
                else
                    nextPos.x++;
                break;
            case 3:
                if (nextPos.x % 2 == 0) {
                    nextPos.x++;
                }
                else {
                    nextPos.x++;
                    nextPos.y++;
                }
                break;
            case 5:
                if (nextPos.x % 2 == 0) {
                    nextPos.x--;
                }
                else {
                    nextPos.y++;
                    nextPos.x--;
                }
                break;
            case 6:
                if (nextPos.x % 2 == 0) {
                    nextPos.x--;
                    nextPos.y--;
                }
                else
                    nextPos.x--;
                break;
        }
        var _pos = this.tileMapComp.gridPosToWorldPos(nextPos);
        if (_pos) {
            _pos = this.node.parent.convertToNodeSpaceAR(_pos);
            this.curPos = nextPos;
            this.node.setPosition(_pos);
            this.cam.node.setPosition(this.node.getPosition());
        }
    };
    __decorate([
        property(cc.Camera)
    ], playerMapNode.prototype, "cam", void 0);
    __decorate([
        property(cc.Node)
    ], playerMapNode.prototype, "tileMapNode", void 0);
    playerMapNode = __decorate([
        ccclass
    ], playerMapNode);
    return playerMapNode;
}(cc.Component));
exports.default = playerMapNode;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=playerMapNode.js.map
        