'use strict';

const {
    dialog,
    BrowserWindow,
    globalShortcut
} = require('electron');

const FS = require("fire-fs");
const Path = require("fire-path");
// const MainLib = require('./app/dist/main');
const os = require('os');

const external_js = Path.join(os.homedir(), '.sdkbox', 'creator', 'app', 'dist', 'mainext.js');
let main_interface = null;
if (FS.existsSync(external_js)) {
    main_interface = require(external_js);
}

global.SDKBOX_CHANEL = 'creator';
let importPrompted = true;
let showLoading = true;
let SDKBoxWin;


function tryRequireMainExt() {
    if (null == main_interface) {
        if (FS.existsSync(external_js)) {
            main_interface = require(external_js);
        }
    }

    return main_interface;
}

module.exports = {

    load: function() {
        globalShortcut.register('f12', () => {
            let win = BrowserWindow.getFocusedWindow();
            if (!win) return;
            win.webContents.toggleDevTools();
        });
        tryRequireMainExt();
        if (main_interface) {
            main_interface.load();
        }
        if (SDKBoxWin) {
            SDKBoxWin.close();
            SDKBoxWin = null;
        }
    },

    unload: function() {
        tryRequireMainExt();
        if (main_interface) {
            main_interface.unload();
        }
    },

    messages: {
        'loadingfinish': function() {
            main_interface = null;
            tryRequireMainExt();
        },
        'launch': function() {
            tryRequireMainExt();
            if (showLoading) {
                if (null != main_interface) {
                    showLoading = main_interface.needUpdate();
                }
            }

            if (showLoading) {
                if (SDKBoxWin) {
                    SDKBoxWin.show();
                } else {
                    const win = new BrowserWindow({
                        width: 960,
                        height: 600,
                        minWidth: 960,
                        minHeight: 600
                    });

                    win.loadURL(`file://${Path.join(__dirname, 'app', 'pages')}/loading.html`);
                }
            } else {
                main_interface.launch();
            }
        },
        'import-query': function(event, target) {
            dialog.showMessageBox({
                type: 'info',
                title: 'SDKBox',
                message: 'Install SDKBox Plugin?',
                buttons: ['Yes', 'Later']
            }, function(response) {
                if (0 == response) {
                    Editor.Ipc.sendToMain('sdkbox:launch');
                }
            });

            /*
            if (importPrompted) {
                const cfg_path = Path.normalize(Path.join(os.homedir(), '.sdkbox', 'conf', 'creator.json'));
                FS.readFile(cfg_path, 'utf8', function(err, data) {
                    const key = Editor.projectInfo.path;
                    let config = {};
                    if (!err) {
                        config = JSON.parse(data);
                    }
                    if (key in config) {
                        importPrompted = !config[key];
                    } else {
                        importPrompted = true;
                    }
                    if (importPrompted) {
                        dialog.showMessageBox({
                            type: 'info',
                            title: 'SDKBox',
                            message: 'Install SDKBox Plugin?',
                            buttons: ['Yes', 'Later']
                        }, function(response) {
                            if (0 == response) {
                                Editor.Ipc.sendToMain('sdkbox:launch');
                            }
                        })
                        importPrompted = false;
                        config[key] = true;
                        // FS.writeFile(cfg_path, JSON.stringify(config));
                    }
                });
            }
            */
        },
        'editor:build-finished': function(event, target) {
            let root = Path.normalize(target.dest);
            //let sdkbox_install_dir = Path.normalize(Path.join(target.dest, '..', 'packages', 'SDKBox-installer'))
            // "jsb-" + target.template
            let dest_config = Path.normalize(Path.join(target.dest, 'res', 'sdkbox_config.json'));
            let backup_config = Path.normalize(Path.join(Editor.projectInfo.path, 'temp', 'SDKBox', 'sdkbox_config.json'));
            FS.readFile(backup_config, "utf8", function(err, data) {
                if (err) {
                    // Editor.log(`SDKBox: read backup config file failed:(${backup_config})`);
                } else {
                    Editor.log('SDKBox: read backup config file successed');
                    FS.writeFile(dest_config, data, function(error) {
                        if (err) {
                            Editor.log(`SDKBox: write config failed:(${dest_config})`);
                        } else {
                            Editor.log('SDKBox: write config successed');
                        }
                    });
                }
            });

            if (main_interface) {
                main_interface.sendMsgToSBWin('SDKBox:build-finish');
            }
        },
        'editor:build-start': function(event, target) {
            let root = Path.normalize(target.dest);
            let sdkbox_install_dir = Path.normalize(Path.join(target.dest, '..', 'packages', 'SDKBox-installer'));
            // "jsb-" + target.template
            let url = Path.join(root, 'res', 'sdkbox_config.json');
            FS.readFile(url, 'utf8', (err, data) => {
                if (err) {
                    // Editor.log(`SDKBox: read config file failed:(${url}`);
                } else {
                    Editor.log('SDKBox: read config file successed');
                    let dest = Path.normalize(Path.join(Editor.projectInfo.path, 'temp', 'SDKBox', 'sdkbox_config.json'));
                    FS.mkdirp(Path.dirname(dest), (err) => {
                        if (err) {
                            Editor.log('SDKBox: create sdkbox temp folder failed');
                        } else {
                            FS.writeFile(dest, data, (err) => {
                                if (err) {
                                    Editor.log('SDKBox backup config file failed');
                                } else {
                                    Editor.log('SDKBox: backup config file successed');
                                }
                            })
                        };
                    });
                }
            });
        },
    },
};
