// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html
const vertShader = `
attribute vec4 a_position;
attribute vec2 a_texCoord;
attribute vec4 a_color;

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

void main()
{
    gl_Position = CC_PMatrix * a_position;
    v_fragmentColor = a_color;
    v_texCoord = a_texCoord;
}
`
const fragShader = `
#ifdef GL_ES
precision lowp float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform vec2 outlineSize;
uniform vec3 outlineColor;

int getIsStrokeWithAngel(float cosangel, float sinangel)
{
    int stroke = 0;
    float a = texture2D(CC_Texture0, vec2(v_texCoord.x + outlineSize.x * cosangel, v_texCoord.y + outlineSize.y * sinangel)).a; // 这句比较难懂，outlineSize * cos(rad)可以理解为在x轴上投影，除以textureSize.x是因为texture2D接收的是一个0~1的纹理坐标，而不是像素坐标
    float num = 1.0;
    if (a >= num)
    {
        stroke = 1;
    }
    return stroke;
}

void main()
{
    vec4 myC = texture2D(CC_Texture0, vec2(v_texCoord.x, v_texCoord.y));
    
    float num = 1.0;
    if (myC.a >= num)
    {
        gl_FragColor = v_fragmentColor * myC;
        return;
    }
    int strokeCount = 0;
    strokeCount += getIsStrokeWithAngel( 1.0, 0.0);
    strokeCount += getIsStrokeWithAngel( 0.9659258262, 0.2588190451);
    strokeCount += getIsStrokeWithAngel( 0.8660254037, 0.5);
    strokeCount += getIsStrokeWithAngel( 0.7071067811, 0.7071067811);
    strokeCount += getIsStrokeWithAngel( 0.5, 0.8660254037);
    strokeCount += getIsStrokeWithAngel( 0.2588190451, 0.9659258262);
    strokeCount += getIsStrokeWithAngel( 0.0, 1.0);
    strokeCount += getIsStrokeWithAngel(-0.2588190451, 0.9659258262);
    strokeCount += getIsStrokeWithAngel(-0.5, 0.8660254037);
    strokeCount += getIsStrokeWithAngel(-0.7071067811, 0.7071067811);
    strokeCount += getIsStrokeWithAngel(-0.8660254037, 0.5);
    strokeCount += getIsStrokeWithAngel(-0.9659258262, 0.2588190451);
    strokeCount += getIsStrokeWithAngel(-1.0, 0.0);
    strokeCount += getIsStrokeWithAngel(-0.9659258262, -0.2588190451);
    strokeCount += getIsStrokeWithAngel(-0.8660254037, -0.5);
    strokeCount += getIsStrokeWithAngel(-0.7071067811, -0.7071067811);
    strokeCount += getIsStrokeWithAngel(-0.5, -0.8660254037);
    strokeCount += getIsStrokeWithAngel(-0.2588190451, -0.9659258262);
    strokeCount += getIsStrokeWithAngel(0.0, -1.0);
    strokeCount += getIsStrokeWithAngel(0.2588190451, -0.9659258262);
    strokeCount += getIsStrokeWithAngel(0.5, -0.8660254037);
    strokeCount += getIsStrokeWithAngel(0.7071067811, -0.7071067811);
    strokeCount += getIsStrokeWithAngel(0.8660254037, -0.5);
    strokeCount += getIsStrokeWithAngel(0.9659258262, -0.2588190451);

    if (strokeCount > 0)
    {
        myC.rgb = outlineColor;
        myC.a = 1.0;
    }

    gl_FragColor = v_fragmentColor * myC;
}
`

cc.Class({
    extends: cc.Component,

    properties: {

    },

    onLoad() {
        this.setShader(this.getComponent(cc.Sprite))
    },

    start() {

    },

    // update (dt) {},

    setShader: function (sprite) {
        var glProgram = new cc.GLProgram();
        glProgram.initWithString(vertShader, fragShader);
        if (!cc.sys.isNative) {
            glProgram.initWithVertexShaderByteArray(vertShader, fragShader);
            glProgram.addAttribute(cc.macro.ATTRIBUTE_NAME_POSITION, cc.macro.VERTEX_ATTRIB_POSITION);
            glProgram.addAttribute(cc.macro.ATTRIBUTE_NAME_COLOR, cc.macro.VERTEX_ATTRIB_COLOR);
            glProgram.addAttribute(cc.macro.ATTRIBUTE_NAME_TEX_COORD, cc.macro.VERTEX_ATTRIB_TEX_COORDS);
        }
        glProgram.link();
        glProgram.updateUniforms();

        glProgram.setUniformLocationWith2f(glProgram.getUniformLocationForName("outlineSize"), 0.1, 0.01);
        glProgram.setUniformLocationWith3f(glProgram.getUniformLocationForName("outlineColor"), 1.0, 0.0, 0.0);    
        sprite._sgNode.setShaderProgram(glProgram);
    },
});
