"use strict";
cc._RF.push(module, 'ca219fM0aVOvaQzp/jgbup1', 'main');
// script/main.js

'use strict';

cc.Class({
    extends: cc.Component,
    properties: {
        designMode: false,
        _images: {
            get: function get() {}
        },
        serenceIdx: 0,
        serenceScript: [cc.Component],
        serences: [cc.Node]
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},
    tryLoad: function tryLoad() {
        function checkReady() {
            var _this2 = this;

            var readyCount = 0;
            var timeOver = false;
            var ready = true;
            for (var idx = 0; idx < img.length; idx++) {
                var imgReady = img[idx];
                if (imgReady) {
                    readyCount++;
                } else {
                    ready = false;
                }
            }
            if (ready && !timeOver) {
                window.$ccTmp._imgTexture = img;
                console.log('资源加载完毕========');
            } else {
                var progress = readyCount / img.length * 100;
                progress = Math.round(progress);
                if (progress >= 95) {
                    setTimeout(function () {
                        if (!ready) {
                            timeOver = true;
                            _this2.tryLoad();
                        }
                    }, 5000);
                }
            }
        }
        for (var idx = 0; idx < window.$ccTmp._images.length; idx++) {
            var url = window.$ccTmp._images[idx];
            (function (url, idx) {
                cc.loader.load(url, function (err, texture) {
                    if (!err) {
                        img[idx] = texture;
                        checkReady();
                    }
                });
            })(url, idx);
        }
    },
    start: function start() {
        var _this = this;
        this.initRes();
        var img = new Array(window.$ccTmp._images.length);
        function checkReady() {
            var readyCount = 0;
            var timeOver = false;
            var ready = true;
            for (var idx = 0; idx < img.length; idx++) {
                var imgReady = img[idx];
                if (imgReady) {
                    readyCount++;
                } else {
                    ready = false;
                }
            }
            if (ready && !timeOver) {
                window.$ccTmp._imgTexture = img;
                setTimeout(function () {
                    if (window.$ccTmp && typeof window.$ccTmp.hideMubanLading == "function") {
                        window.$ccTmp.hideMubanLading();
                    }
                    _this.loadSerence();
                }, 500);
            } else {
                var progress = readyCount / img.length * 100;
                progress = Math.round(progress);
                if (progress >= 95) {
                    setTimeout(function () {
                        if (!ready) {
                            timeOver = true;
                            console.log('资源加载超时=================');
                            if (window.$ccTmp && typeof window.$ccTmp.hideMubanLading == "function") {
                                window.$ccTmp.hideMubanLading();
                            }
                            _this.loadSerence();
                        }
                    }, 15000);
                }
                if (progress >= 100) progress = 99;
                if (window.$ccTmp && typeof window.$ccTmp.setMubanProgress == "function") {
                    window.$ccTmp.setMubanProgress(progress);
                }
            }
        }
        for (var idx = 0; idx < window.$ccTmp._images.length; idx++) {
            var url = window.$ccTmp._images[idx];
            (function (url, idx) {
                cc.loader.load(url, function (err, texture) {
                    if (!err) {
                        img[idx] = texture;
                        checkReady();
                    }
                });
            })(url, idx);
        }
    },
    initRes: function initRes() {
        var _this3 = this;

        window.$ccTmp = window.$ccTmp || {};
        var img = {
            "1": "https://mlimg.qingzhanshi.com/mmbiz/4wB3jaTicUJISib7RgjMbtJgVUUXqHJ2ClXIBScH7iaRDibTXTicicnWiciaqoEVabic2v8F3o6gybUYiaT7NVqiaNqXiaJvJQ/640"
        };
        var imgArr = [];
        if (window && window.picsArray && typeof picsArray == "string") img = JSON.parse(window.picsArray);
        for (var key in img) {
            if (img.hasOwnProperty(key)) {
                var item = img[key];
                imgArr.push(item);
            }
        }
        window.$ccTmp._images = imgArr;
        window.$ccTmp._imageIdx = 0;
        window.$ccTmp.getImgUrl = function () {
            var idx = window.$ccTmp._imageIdx;
            var imgs = window.$ccTmp._images;
            var img = imgs[idx];
            idx++;
            window.$ccTmp._imageIdx = idx % imgs.length;
            return img;
        };
        window.$ccTmp.getImgData = function () {
            var idx = window.$ccTmp._imageIdx;
            var imgs = window.$ccTmp._images;
            var img = imgs[idx];
            var data = {
                img: img
            };
            if (window.$ccTmp._imgTexture) {
                data.texture = window.$ccTmp._imgTexture[idx];
            }
            idx++;
            window.$ccTmp._imageIdx = idx % imgs.length;
            return data;
        };

        window.$ccTmp.nextSerence = function () {
            _this3.loadSerence();
        };
    },
    serenceStart: function serenceStart() {
        var _this4 = this;

        console.log(this.designMode);
        if (this.designMode) return;
        for (var idx = 0; idx < this.serences.length; idx++) {
            this.serences[idx].active = false;
        }
        this.startSerence.active = true;
        cc.log(this.startSerence);
        this.startSerence.opacity = 255;
        this.startSerence.once('animeDone', function () {
            _this4.startSerence.opacity = 0;
            _this4.startSerence.active = false;
            _this4.loadSerence();
        });

        this.startSerence.getComponent(cc.Animation).play();
    },
    loadSerence: function loadSerence() {
        console.log(this.designMode);
        if (this.designMode) return;
        for (var idx = 0; idx < this.serences.length; idx++) {
            if (idx != this.serenceIdx) {
                this.serences[idx].active = false;
            } else {
                this.serences[idx].active = true;
            }
        }
        this.serenceScript[this.serenceIdx].setSerence();
        this.serenceIdx = (this.serenceIdx + 1) % this.serences.length;
    }
});

cc._RF.pop();