"use strict";
cc._RF.push(module, 'a7e45GlETZBoKUg+YYN7pG6', 'Player');
// Script/Player.ts

Object.defineProperty(exports, "__esModule", { value: true });
// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
//https://blog.csdn.net/potato47/article/details/54958538
var Player = /** @class */ (function (_super) {
    __extends(Player, _super);
    function Player() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dirX = 0;
        _this.dirY = 0;
        _this.hSpeed = 60;
        _this.isCollider = false;
        //x轴是否碰撞，0：没有碰撞，-1：左方有碰撞，1：右方有碰撞
        _this.collisionX = 0;
        _this.collisionY = 0;
        //同时碰撞物体的个数
        _this.touchingNumber = 0;
        _this.end = false;
        return _this;
    }
    Player.prototype.onLoad = function () {
        //事件监听
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.keyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.keyUp, this);
        this.body = this.getComponent(cc.RigidBody);
    };
    Player.prototype.start = function () {
    };
    /**
     * 碰撞开始
     * @param other   产生碰撞的另一个碰撞组件
     * @param self    产生碰撞的自身的碰撞组件
     */
    Player.prototype.onBeginContact = function (contact, selfCollider, otherCollider) {
        console.log("发生碰撞..");
        this.node.color = cc.Color.RED;
    };
    Player.prototype.onEndContact = function (contact, selfCollider, otherCollider) {
        this.node.color = cc.Color.WHITE;
    };
    Player.prototype.onCollisionExit = function (other) {
        this.touchingNumber--;
        if (this.touchingNumber === 0) {
            this.node.color = cc.Color.WHITE;
        }
        if (other.touchingX) {
            this.collisionX = 0;
            other.touchingX = false;
        }
        else if (other.touchingY) {
            other.touchingY = false;
            this.collisionY = 0;
        }
    };
    //检测移动move
    Player.prototype.update = function (dt) {
        // let distanceX  = 0;
        // let distanceY = 0;
        // let nextTile = null;
        // if(this.dirX){
        //     distanceX = this.dirX * this.hSpeed * dt;                       
        // }  
        // if(this.dirY){
        //     distanceY = this.dirY * this.hSpeed * dt;                       
        // }  
        // if(this.dirX || this.dirY){
        //     //获得瓦片坐标         
        //   nextTile = GameManager.GetInstance().getTilePropertiesByPosition(cc.v2(this.node.x + distanceX,this.node.y + distanceY));      
        // }
        // if(!nextTile){            
        //     this.node.x += distanceX;
        //     this.node.y += distanceY
        // }
        var cb = cc.v2(this.dirX * this.hSpeed, this.dirY * this.hSpeed);
        this.body.linearVelocity = cb;
    };
    Player.prototype.keyDown = function (event) {
        switch (event.keyCode) {
            case cc.KEY.a:
            case cc.KEY.left:
                this.dirX = -1;
                break;
            case cc.KEY.d:
            case cc.KEY.right:
                this.dirX = 1;
                break;
            case cc.KEY.w:
            case cc.KEY.up:
                this.dirY = 1;
                break;
            case cc.KEY.s:
            case cc.KEY.down:
                this.dirY = -1;
                break;
            default:
                break;
        }
    };
    Player.prototype.keyUp = function (event) {
        switch (event.keyCode) {
            case cc.KEY.a:
            case cc.KEY.d:
            case cc.KEY.left:
            case cc.KEY.right:
                this.dirX = 0;
                break;
            case cc.KEY.w:
            case cc.KEY.s:
            case cc.KEY.up:
            case cc.KEY.down:
                this.dirY = 0;
                break;
            default:
                break;
        }
    };
    Player = __decorate([
        ccclass
    ], Player);
    return Player;
}(cc.Component));
exports.default = Player;

cc._RF.pop();