"use strict";
cc._RF.push(module, 'e1b90/rohdEk4SdmmEZANaD', 'GameManager');
// Script/GameManager.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var GameManager = /** @class */ (function (_super) {
    __extends(GameManager, _super);
    function GameManager() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GameManager_1 = GameManager;
    GameManager.GetInstance = function () {
        return GameManager_1.m_instance;
    };
    GameManager.prototype.onLoad = function () {
        GameManager_1.m_instance = this;
    };
    GameManager.prototype.onEnable = function () {
        //开启物理
        cc.director.getPhysicsManager().enabled = true;
        //   this.debugDrawFlags = cc.director.getPhysicsManager().debugDrawFlags;
        //   cc.director.getPhysicsManager().debugDrawFlags = 
        //       cc.PhysicsManager.DrawBits.e_jointBit |
        //       cc.PhysicsManager.DrawBits.e_shapeBit;
    };
    GameManager.prototype.onDisable = function () {
        //关闭物理
        cc.director.getPhysicsManager().enabled = false;
    };
    GameManager.prototype.start = function () {
        //初始化地图         
        // this._initMap();            
    };
    GameManager.prototype.update = function (dt) {
    };
    /**
    * 像素坐标转换为瓦片坐标
    * @param pos
    */
    GameManager.prototype.getTileCoordFromPosition = function (pos) {
        pos = this.node.convertToWorldSpaceAR(pos);
        var x = Math.floor(pos.x / this.Map.getTileSize().width);
        var y = Math.floor((this.Map.getMapSize().height * this.Map.getTileSize().height - pos.y) / this.Map.getTileSize().height);
        return cc.v2(x, y);
    };
    /**
     * 瓦片坐标转像素坐标
     * @param tileCoord
     */
    GameManager.prototype.getPositionFromTileCoord = function (tileCoord) {
        var v2 = this.node.convertToNodeSpaceAR(this.WallLayer.getPositionAt(tileCoord));
        v2.x = v2.x + this.Map.getTileSize().width / 2;
        v2.y = v2.y + this.Map.getTileSize().height / 2;
        return v2;
    };
    GameManager.prototype.getTilePropertiesByPosition = function (pos) {
        //获得瓦片坐标         
        var tilePos = this.getTileCoordFromPosition(pos);
        //获得瓦片GID
        var tileGID = this.WallLayer.getTileGIDAt(tilePos);
        if (tileGID > 0) {
            var properties = GameManager_1.GetInstance().Map.getPropertiesForGID(tileGID);
            return {
                gid: tileGID,
                properties: properties
            };
        }
        return null;
    };
    GameManager.prototype._initMap = function () {
        //向某一个方向移动的时候 会检测 当前位置+speed 是否会碰撞到墙壁
        var tileSize = this.WallLayer.getMapTileSize();
        var layerSize = this.WallLayer.getLayerSize();
        var tiles = this.WallLayer.getTiles();
        console.log("tileSize->", tileSize);
        console.log("layerSize->", layerSize);
        console.log("tiles->", tiles);
        console.log("瓦片坐标-->", this.getTileCoordFromPosition(cc.v2(8, 0)));
        console.log("像素坐标-->", this.getPositionFromTileCoord(cc.v2(16, 7)));
        // let v2 = this.WallLayer.getPositionAt(cc.v2(0,0));
        // console.log("局部坐标-->",this.node.convertToNodeSpaceAR(v2));
        // for (let i = 0; i < tiles.length; i++) {
        //    let ty = Math.floor(i / layerSize.width);
        //    let tx =  i % layerSize.width;
        //    //格子有内容
        //    if (tiles[i] !== 0) {         
        //     let pos = this.WallLayer.getPositionAt(cc.v2(tx,ty)); 
        //     pos.x = pos.x - 512/2 + 8;
        //     pos.y = pos.y - 240/2 + 8;
        //     let collider : cc.PhysicsBoxCollider = this.Collider.addComponent("cc.PhysicsBoxCollider");              
        //     collider.size = new cc.Size(tileSize.width,tileSize.height);
        //     collider.offset = new cc.Vec2(pos.x,pos.y);            
        //     collider.apply();
        //    }
        // }      
    };
    __decorate([
        property(cc.TiledMap)
    ], GameManager.prototype, "Map", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], GameManager.prototype, "BgLayer", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], GameManager.prototype, "WallLayer", void 0);
    __decorate([
        property(cc.Node)
    ], GameManager.prototype, "Collider", void 0);
    GameManager = GameManager_1 = __decorate([
        ccclass
    ], GameManager);
    return GameManager;
    var GameManager_1;
}(cc.Component));
exports.default = GameManager;

cc._RF.pop();