cc.Class({
    extends: cc.Component,

    properties: {
        a: cc.Node,
        b: cc.Node,
    },

    // use this for initialization
    onLoad: function () {
    },

    start: function () {
        let winSize = cc.director.getWinSize();
        let pos = this.a.getPosition();
        let rt = cc.RenderTexture.create(this.a.width, this.a.height, cc.Texture2D.PIXEL_FORMAT_RGBA8888);
        let leftBottomPoint = cc.p(pos.x + winSize.width / 2 - this.a.width / 2, pos.y + winSize.height / 2 - this.a.height / 2);
        let fullRect = cc.rect(0, 0, winSize.width, winSize.height);
        let viewRect = cc.rect(0, 0, this.a.width, this.a.height);
        rt.setVirtualViewport(leftBottomPoint, fullRect, viewRect);
        cc.director.setCullingEnabled(false);
        rt.begin();
        this.a._sgNode.visit();
        rt.end();
        cc.director.setCullingEnabled(true);

        rt.saveToFile('rt.png', cc.ImageFormat.PNG);

        let sf = rt.getSprite().getSpriteFrame();
        sf.insetLeft = 0;
        sf.insetRight = 0;
        sf.insetTop = 0;
        sf.insetBottom = 0;
        this.b.getComponent(cc.Sprite).spriteFrame = sf;
        this.b.scaleY = -this.b.scaleY;
    }
});
