"use strict";
cc._RF.push(module, 'd3f62RIh/1DLaLJXlYoCNit', 'try');
// try.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {
        a: cc.Node,
        b: cc.Node
    },

    // use this for initialization
    onLoad: function onLoad() {},

    start: function start() {
        var winSize = cc.director.getWinSize();
        var pos = this.a.getPosition();
        var rt = cc.RenderTexture.create(this.a.width, this.a.height, cc.Texture2D.PIXEL_FORMAT_RGBA8888);
        var leftBottomPoint = cc.p(pos.x + winSize.width / 2 - this.a.width / 2, pos.y + winSize.height / 2 - this.a.height / 2);
        var fullRect = cc.rect(0, 0, winSize.width, winSize.height);
        var viewRect = cc.rect(0, 0, this.a.width, this.a.height);
        rt.setVirtualViewport(leftBottomPoint, fullRect, viewRect);
        cc.director.setCullingEnabled(false);
        rt.begin();
        this.a._sgNode.visit();
        rt.end();
        cc.director.setCullingEnabled(true);

        rt.saveToFile('rt.png', cc.ImageFormat.PNG);

        var sf = rt.getSprite().getSpriteFrame();
        sf.insetLeft = 0;
        sf.insetRight = 0;
        sf.insetTop = 0;
        sf.insetBottom = 0;
        this.b.getComponent(cc.Sprite).spriteFrame = sf;
        this.b.scaleY = -this.b.scaleY;
    }
});

cc._RF.pop();