cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!',
        labelPrefab:cc.Prefab,
        labelParent:cc.Node,
    },

    // use this for initialization
    onLoad: function () {
        //this.label.string = this.text;
        this.schedule(()=>{
            this.addLabel();
        }, 2.0)
    },

    clear(){
        if (cc.sys.isNative) {
            jsb.garbageCollect();
        }
    },

    addLabel(){
        if(this.labelParent.childrenCount>0){
            this.labelParent.destroyAllChildren()
        }else{
            let newNode=cc.instantiate(this.labelPrefab)
            this.labelParent.addChild(newNode)
        }
    },

    // called every frame
    update: function (dt) {

    },
});
