// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class ConvertNode extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {

    }

    // update (dt) {}

    convertNode(copyNode: cc.Node){
        this.node.removeAllChildren();
        let debugNode = this.node;
        cc.error("--------------------------------------------------------");
        while (debugNode) {
            let worldPos = copyNode.convertToWorldSpaceAR(cc.Vec2.ZERO);
            let pos = debugNode.convertToNodeSpaceAR(worldPos);
            cc.error("winPos node-%s:", debugNode.name, this.node.position.toString());
            cc.error("beginPos:%s, worldPos:%s, endPos:", copyNode.position.toString(), worldPos.toString(), pos.toString());
            debugNode = debugNode.parent;
        }
        cc.error("--------------------------------------------------------");
        let worldPos = copyNode.convertToWorldSpaceAR(cc.Vec2.ZERO);
        let pos = this.node.convertToNodeSpaceAR(worldPos);
        cc.error("beginPos:%s, worldPos:%s, endPos:", copyNode.position.toString(), worldPos.toString(), pos.toString());
        let node = cc.instantiate(copyNode);
        node.setParent(this.node);
        node.setPosition(pos);
    }
}
