// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    toggle1: cc.Toggle;
    toggle2: cc.Toggle;
    toggle3: cc.Toggle;

    show1: cc.Node;
    show2: cc.Node;
    show3: cc.Node;

    btn_change: cc.Node;

    toggleIndex = 0;

    // LIFE-CYCLE CALLBACKS:

    onLoad() {

        this.toggle1 = this.node.getChildByName("toggle1").getComponent(cc.Toggle);
        this.toggle2 = this.node.getChildByName("toggle2").getComponent(cc.Toggle);
        this.toggle3 = this.node.getChildByName("toggle3").getComponent(cc.Toggle);
        this.toggle1.node.on("toggle", this.onToggleChange, this);
        this.toggle2.node.on("toggle", this.onToggleChange, this);
        this.toggle3.node.on("toggle", this.onToggleChange, this);

        this.show1 = this.node.getChildByName("sprite_splash1");
        this.show2 = this.node.getChildByName("sprite_splash2");
        this.show3 = this.node.getChildByName("sprite_splash3");

        this.btn_change = this.node.getChildByName("button");
        this.btn_change.on("click", this.onClichChange, this);

    }

    start() {
        this.onToggleChange();
    }

    onToggleChange() {
        cc.error("onToggleChange");
        this.show1.active = this.toggle1.isChecked;
        this.show2.active = this.toggle2.isChecked;
        this.show3.active = this.toggle3.isChecked;
    }

    onClichChange() {
        this.toggleIndex++;
        if (this.toggleIndex % 3 == 0) {
            this.toggle1.check();
        } else if (this.toggleIndex % 3 == 1) {
            this.toggle2.check();
        } else if (this.toggleIndex % 3 == 2) {
            this.toggle3.check();
        }
    }

    // update (dt) {}
}
