// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import ConvertNode from "./ConvertNode";

const {ccclass, property} = cc._decorator;

@ccclass
export default class TweenNode extends cc.Component {

    @property(cc.Prefab)
    prefab_tweenNode: cc.Prefab = null;

    @property(cc.Prefab)
    prefab_show: cc.Prefab = null;

    convertNode: cc.Node;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    protected onEnable(): void {
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    }

    protected onDisable(): void {
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    }

    onKeyDown(event: cc.Event.EventKeyboard) {
        let keyCode = event.keyCode;
        if (cc.sys.os == cc.sys.OS_WINDOWS) {
            if (keyCode == 88) {
                this.testTween();
            }
        }
    }

    start() {
    }

    testTween() {
        if (this.convertNode != null) {
            this.convertNode.removeFromParent();
        }
        let node = cc.instantiate(this.prefab_tweenNode);
        node.setParent(this.node);
        node.setPosition(cc.Vec2.ZERO);
        cc.tween(node)
            .to(0.5, {position: node.position.add(cc.v3(0, 50))})
            .call(() => {
                if (!this.convertNode) {
                    this.convertNode = cc.instantiate(this.prefab_show);
                    this.convertNode.setParent(this.node.getParent());
                    this.convertNode.getComponent(cc.Widget).updateAlignment();
                } else {
                    this.convertNode.setParent(this.node.getParent());
                }
                this.convertNode.zIndex = 5;
                this.convertNode.getComponent(ConvertNode).convertNode(node);
                node.destroy();
            })
            .start();
    }

    // update (dt) {}
}
