// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html
var openDataFlag=true;
cc.Class({
    extends: cc.Component,

    properties: {
        ranklayout:{
            default:null,
            type:cc.Layout,
        },
        open:false,
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    TouchEvent(event, customEventData){
        if(event.type==cc.Node.EventType.TOUCH_END){
            if(customEventData=="rank"){
                this.onclick();
            }else if(customEventData=="back"){
                this.open=false;
                this.ranklayout.node.active=false;
            }
        }
    },

    onclick(){
        this.ranklayout.node.active=true;
        if(openDataFlag){
            this.open=true;
            this.tex = new cc.Texture2D();
            var winsz=cc.winSize;
            var node=this.ranklayout.node;
            node.setContentSize(winsz);
            node.on(cc.Node.EventType.TOUCH_END, function (event) {})
            var openDataContext = wx.getOpenDataContext();
            var sharedCanvas = openDataContext.canvas;
            sharedCanvas.width=winsz.width;
            sharedCanvas.height=winsz.height;
        }
    },

    // 刷新开放数据域的纹理
    _updateSubDomainCanvas () {
        if (this.tex!=undefined&&this.tex!=null) {
            var openDataContext = wx.getOpenDataContext();
            var sharedCanvas = openDataContext.canvas;
            this.tex.initWithElement(sharedCanvas);
            this.tex.handleLoadedTexture();
            var spr=this.ranklayout.node.getComponent(cc.Sprite);
            spr.spriteFrame = new cc.SpriteFrame(this.tex);
            
        }
    },

    setBackPosition(){
        var winsz=cc.winSize;
        var backBtn=this.ranklayout.node.getChildByName("backbtn");
        backBtn.x=-winsz.width/2.0+50;
        backBtn.y=winsz.height/2.0-50;
        
    },

    start () {
        this.ranklayout.node.active=false;
    },

    update (dt) {
        if(openDataFlag&&this.open){
            this._updateSubDomainCanvas();
        }
    },
});
