// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class Paintbrush extends cc.Component {
    @property(cc.Graphics)
    public pen: cc.Graphics = undefined;

    private isTouchStart: boolean = false;

    public onLoad() {
        this.pen.clear();
        this.pen.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStartCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMoveCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEndCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchCancleCallback, this);
    }

    public onTouchStartCallback(event: cc.Touch) {
        console.log('pen：', this.pen);
        this.isTouchStart = true;
        const pos = this.pen.node.convertToNodeSpaceAR(event.getLocation());
        // 与lineTo 有位移,这样画一个小点
        this.pen.moveTo(pos.x, pos.y - 0.1);
        this.pen.lineTo(pos.x, pos.y);
        this.pen.stroke();
        this.pen.moveTo(pos.x, pos.y);
    }

    public onTouchMoveCallback(event: cc.Touch) {
        if (this.isTouchStart) {
            const pos = this.pen.node.convertToNodeSpaceAR(event.getLocation());
            this.pen.lineTo(pos.x, pos.y);
            // this.pen.stroke();
            this.pen.moveTo(pos.x, pos.y);
        }
    }

    public onTouchEndCallback(event: cc.Touch) {
        this.isTouchStart = false;
    }

    public onTouchCancleCallback(event: cc.Touch) {
        this.isTouchStart = false;
    }
}
