
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Paintbrush.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '47bdejH0adAM6UYjNwrZVZs', 'Paintbrush');
// Paintbrush.ts

// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Paintbrush = /** @class */ (function (_super) {
    __extends(Paintbrush, _super);
    function Paintbrush() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pen = undefined;
        _this.isTouchStart = false;
        return _this;
    }
    Paintbrush.prototype.onLoad = function () {
        this.pen.clear();
        this.pen.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStartCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMoveCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEndCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchCancleCallback, this);
    };
    Paintbrush.prototype.onTouchStartCallback = function (event) {
        console.log('pen：', this.pen);
        this.isTouchStart = true;
        var pos = this.pen.node.convertToNodeSpaceAR(event.getLocation());
        // 与lineTo 有位移,这样画一个小点
        this.pen.moveTo(pos.x, pos.y - 0.1);
        this.pen.lineTo(pos.x, pos.y);
        this.pen.stroke();
        this.pen.moveTo(pos.x, pos.y);
    };
    Paintbrush.prototype.onTouchMoveCallback = function (event) {
        if (this.isTouchStart) {
            var pos = this.pen.node.convertToNodeSpaceAR(event.getLocation());
            this.pen.lineTo(pos.x, pos.y);
            // this.pen.stroke();
            this.pen.moveTo(pos.x, pos.y);
        }
    };
    Paintbrush.prototype.onTouchEndCallback = function (event) {
        this.isTouchStart = false;
    };
    Paintbrush.prototype.onTouchCancleCallback = function (event) {
        this.isTouchStart = false;
    };
    __decorate([
        property(cc.Graphics)
    ], Paintbrush.prototype, "pen", void 0);
    Paintbrush = __decorate([
        ccclass
    ], Paintbrush);
    return Paintbrush;
}(cc.Component));
exports.default = Paintbrush;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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