"use strict";
cc._RF.push(module, '47bdejH0adAM6UYjNwrZVZs', 'Paintbrush');
// Paintbrush.ts

// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Paintbrush = /** @class */ (function (_super) {
    __extends(Paintbrush, _super);
    function Paintbrush() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pen = undefined;
        _this.isTouchStart = false;
        return _this;
    }
    Paintbrush.prototype.onLoad = function () {
        this.pen.clear();
        this.pen.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStartCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMoveCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEndCallback, this);
        this.pen.node.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchCancleCallback, this);
    };
    Paintbrush.prototype.onTouchStartCallback = function (event) {
        console.log('pen：', this.pen);
        this.isTouchStart = true;
        var pos = this.pen.node.convertToNodeSpaceAR(event.getLocation());
        // 与lineTo 有位移,这样画一个小点
        this.pen.moveTo(pos.x, pos.y - 0.1);
        this.pen.lineTo(pos.x, pos.y);
        this.pen.stroke();
        this.pen.moveTo(pos.x, pos.y);
    };
    Paintbrush.prototype.onTouchMoveCallback = function (event) {
        if (this.isTouchStart) {
            var pos = this.pen.node.convertToNodeSpaceAR(event.getLocation());
            this.pen.lineTo(pos.x, pos.y);
            // this.pen.stroke();
            this.pen.moveTo(pos.x, pos.y);
        }
    };
    Paintbrush.prototype.onTouchEndCallback = function (event) {
        this.isTouchStart = false;
    };
    Paintbrush.prototype.onTouchCancleCallback = function (event) {
        this.isTouchStart = false;
    };
    __decorate([
        property(cc.Graphics)
    ], Paintbrush.prototype, "pen", void 0);
    Paintbrush = __decorate([
        ccclass
    ], Paintbrush);
    return Paintbrush;
}(cc.Component));
exports.default = Paintbrush;

cc._RF.pop();