cc.Class({
    extends: cc.Component,

    properties: {
        collider:cc.PolygonCollider,
    },

    // use this for initialization
    onLoad: function () {
        this.drawing_scene = cc.find("Canvas/bg").getComponent("drawing_scene");
        this.color_type;
        this.color;
        this.size;
        this.is_click = false;
        this.first_draw = true;
        this.set_touch_ctrl();
    },

    set_touch_ctrl:function(){
        cc.director.getCollisionManager().enabled=true;
        var self = this;
        let mwidth = self.node.getContentSize().width;
        let mhight = self.node.getContentSize().height;
        let rt = new cc.RenderTexture(mwidth, mhight);
        self.node._sgNode.addChild(rt);
        rt.begin();
        rt.end();
        this.node.parent.on(cc.Node.EventType.TOUCH_START,function(touch,event){
            var touchLoc = touch.getLocation();
            if(cc.Intersection.pointInPolygon(touchLoc, self.collider.world.points)){
                touchLoc = self.node.convertToNodeSpaceAR(touchLoc);
                touchLoc.x += self.node.getContentSize().width / 2;
                touchLoc.y += self.node.getContentSize().height / 2;
                self.originPoint = touchLoc;
                console.log("page2")
                self.is_click=true;
            }
            return true;

        }.bind(this),this.node)
        this.node.parent.on(cc.Node.EventType.TOUCH_MOVE,function(touch,event){
            var touchLoc = touch.getLocation();
            if(cc.Intersection.pointInPolygon(touchLoc, self.collider.world.points)){
                if(self.is_click){
                    touchLoc = self.node.convertToNodeSpaceAR(touchLoc);
                    touchLoc.x += self.node.width / 2;
                    touchLoc.y += self.node.height / 2;
					//涂色
                    if(self.color_type==6){
                        let originPoint = self.originPoint;
                        let e1 = new cc.DrawNode();
                        e1.drawSegment(originPoint, touchLoc, self.size*2,self.color);
                        rt.begin();
                        e1.visit();
                        rt.end();
                        self.originPoint = touchLoc;
                        if(self.first_draw){
                            self.first_draw = false;
                            self.drawing_scene.set_is_draw(true);
                        }else{

                        }
                    }
					//橡皮擦
					else if(self.color_type==7){
                        // let originPoint = self.originPoint;
                        // let e2 = new cc.DrawNode();
                        // e2.drawSegment(originPoint, touchLoc, self.size/2,self.color);
                        // e2.setBlendFunc(771,0);
                        // rt.begin();
                        // e2.visit();
                        // rt.end();
                        // self.originPoint = touchLoc;
                    }
                    
                }else{
					//手指离开画板后在不离开的情况下再次划回画板
                    touchLoc = self.node.convertToNodeSpaceAR(touchLoc);
					//涂色
                    if(self.color_type==6){
                        var touchLoc2 = touchLoc;
                        touchLoc.x += self.node.getContentSize().width / 2;
                        touchLoc.y += self.node.getContentSize().height / 2;
                        self.originPoint = touchLoc;
                        let originPoint = self.originPoint;
                        let e1 = new cc.DrawNode();
                        e1.drawSegment(originPoint, touchLoc, self.size*2,self.color);
                        rt.begin();
                        e1.visit();
                        rt.end();
                        self.originPoint = touchLoc;
                        self.is_click=true;
                    }
					//橡皮擦
					else if(self.color_type==7){
                        //var touchLoc2 = touchLoc;
                        //touchLoc.x += self.node.getContentSize().width / 2;
                        //touchLoc.y += self.node.getContentSize().height / 2;
                        //self.originPoint = touchLoc;
                        //let originPoint = self.originPoint;
                        //let e2 = new cc.DrawNode();
                        //e2.drawSegment(originPoint, touchLoc, self.size/2,self.color);
                        //e2.setBlendFunc(771,0);
                        //rt.begin();
                        //e2.visit();
                        //rt.end();
                        //self.originPoint = touchLoc;
                        //self.is_click=true;
                    }
                    
                }
            }else{
                self.is_click=false;
            }   
            return true;
        }.bind(this),this.node)
        this.node.parent.on(cc.Node.EventType.TOUCH_END,function(){
            if(self.is_click){
                self.is_click = false;
            }           
        }.bind(this),this.node)
        this.node.parent.on(cc.Node.EventType.TOUCH_CANCEL,function(){
            self.is_click = false;
        }.bind(this),this.node)
    },

    set_color:function(num){
        var color;
        if(num==0){

        }else if(num==1){

        }else if(num==2){

        }else if(num==3){

        }else if(num==4){

        }else if(num==5){

        }else if(num==6){
            color=cc.hexToColor("b83e08");
        }else if(num==7){
            color=cc.hexToColor("ffffff");
        }
        this.color = color;
        this.color_type = num;  
    },

    set_size:function(num){
        this.size = num;
    },

    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
});
