cc.Class({
    extends: cc.Component,

    properties: {
        tip: cc.Label,
        graphics: cc.Graphics,
        _rightMenu:cc.Node,
        _rect: cc.Rect
    },

    start () {
        this._rightMenu = cc.find('Menu/right');
        this._baseX = this._rightMenu ? this._rightMenu.x : 0;
        this.onResized();
        cc.view.on('canvas-resize', this.onResized, this);
    },

    onResized () {
        this._rect = cc.sys.getSafeAreaRect();
        let canvasSize = cc.view.getVisibleSize();
        this.graphics.clear();
        this.graphics.rect(-canvasSize.width / 2 + this._rect.x, -canvasSize.height / 2 + this._rect.y, this._rect.width, this._rect.height);
        this.graphics.fillColor = new cc.color(241, 148, 138, 66);
        this.graphics.fill();
        this.graphics.stroke();
        this.tip.string = this._rect;

        // move menu btns to safe area
        if (this._rightMenu) {
            this._rightMenu.x = this._baseX - this._rect.x;
        }
    },

    onDisable () {
        if (this._rightMenu) {
            this._rightMenu.x = this._baseX;
        }
        cc.view.off('canvas-resize', this.onResized, this);
    }
});
