import { _decorator, Component, systemEvent, SystemEventType, Touch, EventTouch, Node, CameraComponent, ModelComponent, geometry } from 'cc';
import { tool, option } from './tool/ray';
const { ccclass, property } = _decorator;

@ccclass('main')
export class main extends Component {
    // private
    // public
    @property({displayName: "摄像机", type: CameraComponent})
    carema: CameraComponent = null;
    @property({displayName: "default-模型", type: ModelComponent})
    default_model: ModelComponent = null;
    @property({displayName: "scale-模型", type: ModelComponent})
    scale_model: ModelComponent = null;

    onLoad() {
        // 监听点击事件
        systemEvent.on(SystemEventType.TOUCH_START, this.touch_start, this);
    }

    /**触控开始 */
    public touch_start(touch_: Touch, event_: EventTouch): void {
        tool.ray.reset_option();
        // 首次根据默认配置获取模型到摄像机距离
        option.distance = tool.ray.check_model_dist(this.carema, this.default_model, touch_);
        if (option.distance > 0) {
            console.log("default组模型到摄像机距离: " + option.distance);
            // 二次根据手动配置检测射线是否与模型碰撞
            if (tool.ray.check_model(this.carema, this.default_model, touch_, true)) {
                console.log("default组使用指定射线长度检测碰撞成功");
            } else {
                console.log("default组使用指定射线长度检测碰撞失败");
            }
        }

        tool.ray.reset_option();
        // 首次根据默认配置获取模型到摄像机距离
        option.distance = tool.ray.check_model_dist(this.carema, this.scale_model, touch_);
        if (option.distance > 0) {
            console.log("scale组模型到摄像机距离: " + option.distance);
            // 二次根据手动配置检测射线是否与模型碰撞
            if (tool.ray.check_model(this.carema, this.scale_model, touch_, true)) {
                console.log("scale组使用指定射线长度检测碰撞成功");
            } else {
                console.log("scale组使用指定射线长度检测碰撞失败");
            }
        }
    }
}