import { _decorator, geometry, Touch, CanvasComponent, Vec2, UITransformComponent, CameraComponent, PhysicsSystem, ColliderComponent, ModelComponent } from 'cc';

/**@ 射线参数配置：
** mode：
1. ALL-检测射线路径上的所有碰撞体, 检测到的结果顺序不是固定的
2. ANY-检测射线路径上任意的碰撞体, 一旦检测到任何碰撞体，将立刻结束检测其他的碰撞体
3. CLOSEST-检测射线路径上最近的碰撞体
** distance：射线距离
** mask：掩码
** trigger：是否检测触发器*/
export let option: tool.ray.option_inter = {
    mode:       null,
    distance:   null,
    mask:       null,
    trigger:    null,
};

export namespace tool {
    export namespace ray {
        /**射线参数配置接口 */
        export interface option_inter {
            mode:       geometry.ERaycastMode,
            distance:   number,
            mask:       number,
            trigger:    boolean,
        }

        /**重置射线配置 */
        export function reset_option(): void {
            option.mode = geometry.ERaycastMode.CLOSEST;
            option.distance = 10000000;
            option.mask = 0xffffffff,
            option.trigger = false
        }

        /**UITransformComponent碰撞 */
        export function check_ui(canvas_: CanvasComponent, ui_: UITransformComponent, touch_: Touch): boolean {
            touch_.getLocation(_touch_pos);
            canvas_.camera.screenPointToRay(_ray, _touch_pos.x, _touch_pos.y);
            ui_.getComputeAABB(_aabb);
            return Boolean(geometry.intersect.ray_aabb(_ray, _aabb));
        }

        /**Collider碰撞 */
        export function check_collider(camera_: CameraComponent, collider_: ColliderComponent, touch_: Touch, option_: boolean = false): boolean {
            touch_.getLocation(_touch_pos);
            camera_.screenPointToRay(_touch_pos.x, _touch_pos.y, _ray);
            if (!option_) {
                reset_option();
            }
            if (PhysicsSystem.instance.raycast(_ray, option.mask, option.distance, option.trigger)) {
                const result = PhysicsSystem.instance.raycastResults;
                for (let i = 0; i < result.length; ++i) {
                    if (result[i].collider.node.uuid == collider_.node.uuid) {
                        return true;
                    }
                }
            }
            return false;
        }

        /**Collider距离 */
        export function check_collider_dist(camera_: CameraComponent, collider_: ColliderComponent, touch_: Touch, option_: boolean = false): number {
            if (check_collider(camera_, collider_, touch_, option_)) {
                return camera_.node.getPosition().subtract(collider_.node.getPosition()).length();
            }
            return -1;
        }

        /**Model碰撞 */
        export function check_model(camera_: CameraComponent, model_: ModelComponent, touch_: Touch, option_: boolean = false): boolean {
            touch_.getLocation(_touch_pos);
            camera_.screenPointToRay(_touch_pos.x, _touch_pos.y, _ray);
            if (!option_) {
                reset_option();
            }
            return geometry.intersect.ray_model(_ray, model_.model, option);
        }

        /**Model距离 */
        export function check_model_dist(camera_: CameraComponent, model_: ModelComponent, touch_: Touch, option_: boolean = false): number {
            if (check_model(camera_, model_, touch_, option_)) {
                return _ray.o.subtract(model_.node.getPosition()).length();
            }
            return -1;
        }
        
        let _aabb       = new geometry.aabb();
        let _ray        = new geometry.ray();
        let _touch_pos  = new Vec2();
    }
}