'use strict';

// var Fs = require('fs');
// var Path = require('path');
var path = require('path');
var Fs = require('fs');
let sdkMap = new Map([
    ['web-mobile', 'h5'],
    ['vivo-runtime', 'vivo'],
    ['oppo-runtime', 'oppo'],
    ['qqplay', 'qq'],
    ['wechatgame', 'wx'],
    ['quickgame', 'oppo'],
    ['qgame', 'vivo'],
])
const subpackages_path = ['resources/Images', 'resources/Sound'];
const subpackages = [];
let cacheMeta = {};
let platType = null;
let metaChanged = false;





function onBuildStart(options, callback) {
    Editor.log('subpackages-onBuildStart');
    Editor.log('Building platform: ' + options.platform + '  actualPlatform: ' + options.actualPlatform + ' to ' + options.dest); // 你可以在控制台输出点什么
    let platType = sdkMap.get(options.actualPlatform || options.platform)
    if (platType !== 'wx') {
        metaChanged = true;
        for (let i = 0; i < subpackages_path.length; i++) {
            const element = subpackages_path[i];
            changeAttr(element);
        }
    }
    if (callback) {
        callback();
    }
}

function onBuildFinish(options, callback) {}

function onBeforeBuildFinish(options, callback) {
    //Editor.log('Building platform: ' + options.platform + '  actualPlatform: ' + options.actualPlatform + ' to ' + options.dest); // 你可以在控制台输出点什么
    //  根据平台类型  获取队形sdk
    Editor.log("还原 Meta");
    if (platType !== 'wx') {
        for (let i = 0; i < subpackages_path.length; i++) {
            const element = subpackages_path[i];
           
            changeAttr(element, true);
        }
    }
    metaChanged = false;
    callback();

}

function changeAttr(file, reduction) {
    let oriFile = "db://assets/" + file;
    // let metaFile = Path.join(Editor.assetdb.urlToFspath(oriFile), '.meta');
    let metaFile = Editor.assetdb.urlToFspath(oriFile)+'.meta';

    let dataStr = null;
    if (reduction) { //还原
        if(metaChanged){
            Editor.log(`执行 还原 ${metaFile} 子包设置`);
            dataStr = cacheMeta[file];
            Fs.writeFileSync(metaFile, dataStr);
            Editor.assetdb.refresh(oriFile);
        }else{
            Editor.log(`，文件未被修改，不执行还原 ${metaFile} 子包设置`);
        }
    } else {//如果不是微信平台，则把子包设置为非子包
        
        Editor.log(`执行 取消 ${metaFile} 的子包设置`);
        dataStr = Fs.readFileSync(metaFile, 'utf-8');
        cacheMeta[file] = dataStr;
        let data = JSON.parse(dataStr);
        data.isSubpackage = false;
        
        Editor.log(`执行 写入文件 ${JSON.stringify(data,null,2)}`);
        Fs.writeFileSync(metaFile, JSON.stringify(data,null,2));

        Editor.assetdb.refresh(oriFile);
    }
}

module.exports = {
    load() {


        Editor.Builder.on('build-start', onBuildStart);
        Editor.Builder.on('before-change-files', onBeforeBuildFinish);
    },

    unload() {
        Editor.Builder.removeListener('build-start', onBuildStart);
        Editor.Builder.removeListener('before-change-files', onBeforeBuildFinish);
    },

    // register your ipc messages here
    messages: {
        'open'() {
            // open entry panel registered in package.json
            Editor.Panel.open('子包插件');
        },
        'clicked'() {
            Editor.log('Button clicked!');
        }
    },
};