(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/HotUpdate.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'a5f6aE2XBpCTrudkOM2sK0v', 'HotUpdate', __filename);
// Script/HotUpdate.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu;
// /**
//  * 热更事件枚举
//  */
// export enum HotUpdateEventType {
//     HOT_NEED, // 需要更新
//     HOT_ERROE, // 更新出错
//     HOT_PASSED, // 不需要更新,直接通过
//     HOT_UPDATING, // 正在更新
//     CHECK_UPDATE, // 通知进行检查更新
//     START_UPDATE, // 通知开始进行更新
//     RETRY_UPDATE  // 通知尝试重新更新
// }
var HotUpdate = /** @class */ (function (_super) {
    __extends(HotUpdate, _super);
    function HotUpdate() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.manifestUrl = null;
        _this._updating = false;
        _this._canRetry = false;
        _this._storagePath = '';
        _this._assetManager = null;
        return _this;
    }
    // private _failCount: number = 0;
    HotUpdate.prototype.onInitData = function () {
        // this.Event.on("CHECK_UPDATE", this.checkUpdate.bind(this));
        // this.Event.on("START_UPDATE", this.hotUpdate.bind(this));
        // this.Event.on("RETRY_UPDATE", this.retry.bind(this));
    };
    HotUpdate.prototype.onLoad = function () {
        if (!cc.sys.isNative)
            return;
        this._storagePath = ((jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/') + 'remote-assets');
        this._assetManager = new jsb.AssetsManager('', this._storagePath, this.versionCompareHandle);
        this._assetManager.setVerifyCallback(this.assetsVerify.bind(this));
        if (cc.sys.os === cc.sys.OS_ANDROID) {
            this._assetManager.setMaxConcurrentTask(2);
        }
        // cc.log('远程资源的存储路径 : ' + this._storagePath);
    };
    HotUpdate.prototype.start = function () {
        this.checkUpdate();
    };
    /**
     *  检查更新回调
     */
    HotUpdate.prototype.checkCb = function (event) {
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                console.log("HOT_CHECK", "ERROR_NO_LOCAL_MANIFEST");
                // console.log("没有发现本地清单文件，跳过热更新.");
                // this.Event.emit(HotUpdateEventType[HotUpdateEventType.HOT_PASSED], event);
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
                console.log("HOT_CHECK", "ERROR_DOWNLOAD_MANIFEST");
                break;
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                console.log("HOT_CHECK", "ERROR_PARSE_MANIFEST");
                // console.log("下载清单文件失败，跳过热更新.");
                // this.Event.emit(HotUpdateEventType[HotUpdateEventType.HOT_ERROE], event);
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                console.log("HOT_CHECK", "ALREADY_UP_TO_DATE");
                // console.log("当前已经是最新版本.");
                // this.Event.emit(HotUpdateEventType[HotUpdateEventType.HOT_PASSED], event);
                break;
            case jsb.EventAssetsManager.NEW_VERSION_FOUND:
                console.log("HOT_CHECK", "NEW_VERSION_FOUND");
                // console.log('找到新版本，请尝试更新.');
                // this.Event.emit(HotUpdateEventType[HotUpdateEventType.HOT_NEED], event);
                this.hotUpdate();
                break;
            default:
                return;
        }
        this._assetManager.setEventCallback(null);
        this._updating = false;
    };
    /**
     * 更新回调
     */
    HotUpdate.prototype.updateCb = function (event) {
        // var needRestart = false;
        // var failed = false;
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                console.log("HOT_UPDATE", "ERROR_NO_LOCAL_MANIFEST");
                // failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:
                console.log("HOT_UPDATE", "UPDATE_PROGRESSION");
                // console.log('正在更新.');
                // this.Event.emit(HotUpdateEventType[HotUpdateEventType.HOT_UPDATING], event);
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
                console.log("HOT_UPDATE", "ERROR_DOWNLOAD_MANIFEST");
                break;
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                console.log("HOT_UPDATE", "ERROR_PARSE_MANIFEST");
                // console.log('下载清单文件失败，跳过热更新.');
                // this.Event.emit(HotUpdateEventType[HotUpdateEventType.HOT_ERROE], event);
                // failed = true;
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                console.log("HOT_UPDATE", "ALREADY_UP_TO_DATE");
                // console.log('当前已经是最新版本.');
                // this.Event.emit("PASSED", event);
                // failed = true;
                // cc.game.restart();
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                console.log("HOT_UPDATE", "UPDATE_FINISHED");
                // console.log('更新完成. ' + event.getMessage());
                // this.Event.emit("FINISHED", event);
                // needRestart = true;
                // cc.game.restart();
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                console.log("HOT_UPDATE", "UPDATE_FAILED");
                // console.log('更新失败. ' + event.getMessage());
                // this.Event.emit(HotUpdateEventType[HotUpdateEventType.HOT_ERROE], event);
                // this.Event.emit("HOT_ERROE", event);
                // this._updating = false;
                // this._canRetry = true;
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                console.log("HOT_UPDATE", "ERROR_UPDATING");
                // console.log('资源更新错误: ' + event.getAssetId() + ', ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                console.log("HOT_UPDATE", "ERROR_DECOMPRESS");
                // console.log('资源更新错误: ' + event.getMessage());
                break;
            default:
                break;
        }
        // if (failed) {
        //     this._assetManager.setEventCallback(null);
        //     this._updating = false;
        // }
        // if (needRestart) {
        //     this._assetManager.setEventCallback(null);
        //     var searchPaths = jsb.fileUtils.getSearchPaths();
        //     var newPaths = this._assetManager.getLocalManifest().getSearchPaths();
        //     Array.prototype.unshift.apply(searchPaths, newPaths);
        //     cc.sys.localStorage.setItem('HotUpdateSearchPaths', JSON.stringify(searchPaths));
        //     jsb.fileUtils.setSearchPaths(searchPaths);
        //     cc.audioEngine.stopAll();
        //     cc.game.restart();
        // }
    };
    /**
     * 重新下载失败的资源
     */
    HotUpdate.prototype.retry = function () {
        if (!this._updating && this._canRetry) {
            this._canRetry = false;
            // console.log('重试失败的资源...');
            this._assetManager.downloadFailedAssets();
        }
    };
    /**
     * 检查更新
     */
    HotUpdate.prototype.checkUpdate = function () {
        if (this._updating) {
            return;
        }
        this.loadLocalManifest();
        if (!this._assetManager.getLocalManifest() || !this._assetManager.getLocalManifest().isLoaded()) {
            // this.Event.emit("PASSED", { msg: "未能加载本地清单 ..." });
            return;
        }
        console.log("HOT", "检查更新");
        this._assetManager.setEventCallback(this.checkCb.bind(this));
        this._assetManager.checkUpdate();
        this._updating = false;
    };
    /**
     * load对应清单文件
     */
    HotUpdate.prototype.loadLocalManifest = function () {
        // console.log("load清单文件")
        if (this._assetManager.getState() === jsb.AssetsManager.State.UNINITED) {
            // Resolve md5 url
            var url = this.manifestUrl.nativeUrl;
            if (cc.loader.md5Pipe) {
                url = cc.loader.md5Pipe.transformURL(url);
            }
            // console.log("清单文件地址:", url);
            this._assetManager.loadLocalManifest(url);
        }
    };
    /**
     * 进行热更新
     */
    HotUpdate.prototype.hotUpdate = function () {
        console.log("HOT", "进行热更新");
        // console.log(this._assetManager, this._updating);
        if (this._assetManager && !this._updating) {
            this._assetManager.setEventCallback(this.updateCb.bind(this));
            // load对应清单文件
            this.loadLocalManifest();
            // this._failCount = 0;
            this._assetManager.update();
            this._updating = true;
        }
    };
    /**
     * //设置你自己的版本比较处理器，版本和B是字符串版本
     * //如果返回值大于0,versionA大于B
     * //如果返回值为0,versionA等于B
     * //如果返回值小于0，则versionA小于B
     * @param versionA
     * @param versionB
     */
    HotUpdate.prototype.versionCompareHandle = function (versionA, versionB) {
        if (versionA == versionB)
            return 0;
        // cc.log("JS Custom Version Compare: version A is " + versionA + ', version B is ' + versionB);
        var vA = versionA.split('.');
        var vB = versionB.split('.');
        for (var i = 0; i < vA.length; ++i) {
            var a = parseInt(vA[i]);
            var b = parseInt(vB[i] || 0);
            if (a === b) {
                continue;
            }
            else {
                return a - b;
            }
        }
        if (vB.length > vA.length) {
            return -1;
        }
        else {
            return 0;
        }
    };
    ;
    /**
     * //设置验证回调，但我们还没有md5检查函数，所以只打印一些消息
     * //如果验证通过，返回true，否则返回false
     */
    HotUpdate.prototype.assetsVerify = function (path, asset) {
        var compressed = asset.compressed;
        var expectedMD5 = asset.md5;
        var relativePath = asset.path;
        if (compressed) {
            console.log("HOT", "验证通过: " + relativePath);
            return true;
        }
        else {
            console.log("HOT", "验证通过: " + relativePath + ' (' + expectedMD5 + ')');
            return true;
        }
    };
    HotUpdate.prototype.update = function (dt) {
    };
    HotUpdate.prototype.onDestroy = function () {
        this._assetManager && this._assetManager.setEventCallback(null);
    };
    __decorate([
        property({ type: cc.Asset })
    ], HotUpdate.prototype, "manifestUrl", void 0);
    HotUpdate = __decorate([
        ccclass,
        menu("扩展组件/HotUpdate")
    ], HotUpdate);
    return HotUpdate;
}(cc.Component));
exports.HotUpdate = HotUpdate;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=HotUpdate.js.map
        