(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/scrites/Decompression_GameSound.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '82fabKgTqlJT5g9AYl+iVWD', 'Decompression_GameSound', __filename);
// scrites/Decompression_GameSound.ts

Object.defineProperty(exports, "__esModule", { value: true });
var GameSound = /** @class */ (function () {
    function GameSound() {
    }
    GameSound.soundURL = {
        broke_smash1: "broke_smash1",
    };
    GameSound.gameFun = {
        Set_JSON: function (key, userData) {
            cc.sys.localStorage.setItem(key, JSON.stringify(userData));
        },
        Get_JSON: function (key, defaultData) {
            if (defaultData === void 0) { defaultData = null; }
            var data = cc.sys.localStorage.getItem(key);
            if (data === null || data === '') {
                data = defaultData;
            }
            return JSON.parse(data);
        }
    };
    GameSound.gameSound = {
        /*================================播放游戏背景声音================================*/
        PlayMusic: null,
        playMusics: function (path) {
            if (GameSound.gameFun.Get_JSON("music", true)) {
                if (this.playMusic)
                    this.stopMusic();
                cc.loader.loadRes(path, cc.AudioClip, function (err, clip) {
                    if (err) {
                        console.log("加载失败........");
                        return;
                    }
                    this.playMusic = cc.audioEngine.playMusic(clip, true);
                }.bind(this));
            }
            else {
                this.stopMusic();
            }
        },
        /*暂停背景声音*/
        pauseMusic: function () {
            var musicbool = cc.audioEngine.isMusicPlaying();
            if (musicbool) {
                cc.audioEngine.pauseMusic();
            }
        },
        // /*停止背景声音*/
        // stopMusic: function () {      
        //     let musicbool = cc.audioEngine.isMusicPlaying();
        //     if(musicbool)
        //     {
        //         cc.audioEngine.stop(this.playMusic);
        //         this.playMusic = null;
        //     }
        // },
        /*恢复背景声音*/
        resumeMusic: function () {
            cc.audioEngine.resumeMusic();
        },
        /*停止播放声音*/
        stopMusic: function () {
            cc.audioEngine.stopMusic();
            this.playMusic = null;
        },
        /*================================播放游戏音效================================*/
        /*停止播放声音*/ //音效
        playSound: null,
        stopSound: function (path) {
            if (path === void 0) { path = null; }
            cc.audioEngine.stop(this.playSound);
            this.playSound = null;
        },
        /*播放声音*/ //音效
        playSources: function (path) {
            if (GameSound.gameFun.Get_JSON("sound", true)) {
                if (this.loadingAudio(path))
                    cc.loader.loadRes(path, cc.AudioClip, function (err, clip) {
                        if (err) {
                            console.log("加载失败........");
                            return;
                        }
                        this.playSound = cc.audioEngine.playEffect(clip, false);
                    }.bind(this));
            }
        },
        /*重复播放播放声音*/ //音效
        playSourcesLoop: function (path) {
            if (GameSound.gameFun.Get_JSON("sound", true)) {
                if (this.loadingAudio(path))
                    cc.loader.loadRes(path, cc.AudioClip, function (err, clip) {
                        if (err) {
                            console.log("加载失败........");
                            return;
                        }
                        this.playSound = cc.audioEngine.playEffect(clip, true);
                    }.bind(this));
            }
        },
        audioArray: [],
        loadingAudio: function (url) {
            var _this = this;
            for (var _i = 0, _a = this.audioArray; _i < _a.length; _i++) {
                var audio = _a[_i];
                if (audio == url) {
                    return false;
                }
            }
            this.audioArray.push(url);
            setTimeout(function () {
                _this.audioArray.length = 0;
            }, 0);
            return true;
        },
        /** 是否有背景音乐在播放 */
        isMusicPlaying: function () {
            var musicbool = cc.audioEngine.isMusicPlaying();
            return musicbool;
        },
        /** 设置背景音乐音量 */
        setMusicVolume: function (volume) {
            var musicbool = cc.audioEngine.isMusicPlaying();
            if (musicbool) {
                cc.audioEngine.setMusicVolume(volume);
            }
        },
        /** 获取背景音乐音量 */
        getMusicVolume: function () {
            var volume = cc.audioEngine.getMusicVolume();
            return volume;
        },
        /** 设置音效音量 */
        setSoundVolume: function (volume) {
            cc.audioEngine.setEffectsVolume(volume);
        },
        /** 获取音效音量 */
        getSoundVolume: function () {
            var volume = cc.audioEngine.getEffectsVolume();
            return volume;
        },
    };
    return GameSound;
}());
exports.GameSound = GameSound;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Decompression_GameSound.js.map
        