"use strict";
cc._RF.push(module, '4b20euUqCtHep+EKBz48chY', 'player');
// Script/player.js

"use strict";

//var kong = require("kong");
cc.Class({
    extends: cc.Component,

    properties: {
        con: cc.Node
    },

    onLoad: function onLoad() {
        // this.kong = this.con.getComponent("kong");
        // cc.log(this.kong.angle);
        cc.director.getCollisionManager().enabled = true;
        cc.director.getCollisionManager().enabledDebugDraw = true;
        cc.director.enabledDrawBoundingBox = true;
        this.pen = false;
        this.kz = this.con.getComponent("kong");
    },
    start: function start() {},

    onCollisionEnter: function onCollisionEnter(other, self) {
        this.pen = true;
        this.node.color = cc.Color.RED;
        var preAabb = self.world.preAabb;
        // console.log(preAabb);
        // console.log(self.world);
        // self.x = preAabb.x;
        // self.y = preAabb.y;
        var selfAabb = self.world.aabb;
        var otherAabb = other.world.aabb;

        if (cc.Intersection.rectRect(selfAabb, otherAabb)) {
            if (Math.cos(this.kz.radian) < 0 && selfAabb.xMax > otherAabb.xMax) {
                console.log(otherAabb.xMax + " " + this.node.x);
                this.node.x = otherAabb.xMax - this.node.parent.x + this.node.width / 2;
            }
        }
    },
    onCollisionStay: function onCollisionStay(other) {
        // console.log('on collision stay');
    },

    onCollisionExit: function onCollisionExit() {
        this.pen = false;
    },

    update: function update(dt) {

        var player = this.node;

        if (this.kz.radian != -1 && !this.pen) {
            player.y += Math.sin(this.kz.radian) * dt * 90;
            player.x += Math.cos(this.kz.radian) * dt * 90;
        }
    }
});

cc._RF.pop();