"use strict";
cc._RF.push(module, 'dfd965Mui1E4bHMH4Gan79K', 'map.js');
// Script/map.js.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        prefab: cc.Prefab
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad: function onLoad() {
        this.map = [];
        this.width = 35;
        this.height = 50;
        this.randomMap();
    },
    randomMap: function randomMap() {
        for (var i = 0; i < this.height; i++) {
            this.map[i] = [];
            for (var j = 0; j < this.width; j++) {
                this.map[i][j] = Math.random() * 100 > 70 ? 1 : 0;
            }
        }
        //    cc.log(this.map);
        //     for(var i = 0; i < 13; i++){
        this.smoothMap();
        //     }


        this.drawMap();
        // var a = [
        //     [0,0,0],
        //     [1,0,0],
        //     [1,0,1]

        // ];
        // this.map = a;
        // console.log(this.getCount(1,1));
    },
    drawMap: function drawMap() {
        var xp = this.node.width / 2;
        var yp = this.node.height / 2;
        for (var i = 0; i < this.height; i++) {
            for (var j = 0; j < this.width; j++) {
                if (this.map[i][j] === 1) {
                    var prefab = cc.instantiate(this.prefab);
                    prefab.setScale(0.25);
                    // prefab.height = 100;
                    var x = i * prefab.width / 4 - xp + prefab.width / 2;
                    var y = j * prefab.height / 4 - yp + prefab.height / 2;
                    prefab.setPosition(x, y);

                    this.node.addChild(prefab);
                }
            }
        }
    },
    smoothMap: function smoothMap() {
        for (var i = 1; i < this.height - 1; i++) {
            for (var j = 1; j < this.width - 1; j++) {
                var count = this.getCount(i, j);
                // console.log(count+"========================");
                // if(this.map[i][j]==1){
                if (count >= 4) {
                    this.map[i][j] = 1;
                } else {
                    this.map[i][j] = 0;
                }
                // }else{
                //     if(count>=4){
                //         this.map[i][j] = 1;
                //     }else{
                //         this.map[i][j] = 0;
                //     }
                // }

            }
        }
    },
    getCount: function getCount(x, y) {
        var count = 0;
        for (var a = x - 1; a <= x + 1; a++) {
            for (var b = y - 1; b <= y + 1; b++) {
                if (a != x || b != y) {
                    count += this.map[a][b];
                }
            }
        }
        return count;
    },
    start: function start() {}
}

// update (dt) {},
);

cc._RF.pop();