(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/conzhi.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '8c22e9sK1RMRJrgCKJkeCLb', 'conzhi', __filename);
// Script/conzhi.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        conzhi: cc.Node
    },

    onLoad: function onLoad() {
        this.anim = this.node.getComponent(cc.Animation);
        this.kz = this.conzhi.getComponent("kong");
        this.v = "leftUP";
        this.collider = false;
    },
    start: function start() {},
    update: function update(dt) {
        // console.log(this.radian * (180/Math.PI));
        var angle = this.kz.radian * (180 / Math.PI);
        if (this.kz.radian != -1) {
            // console.log(angle);

            if (angle <= 180 && angle >= 90) {
                if (this.v != "leftUp") {
                    console.log(this.v);
                    this.anim.play("leftUp");
                    this.v = "leftUp";
                }
            } else if (angle < 90 && angle > 0) {
                if (this.v != "rightUp") {
                    this.anim.play("rightUp");
                    this.v = "rightUp";
                }
            } else if (angle > -90 && angle < 0) {
                if (this.v != "rightDown") {
                    this.anim.play("rightDown");
                    this.v = "rightDown";
                }
            } else if (angle <= -90 && angle >= -180) {
                if (this.v != "leftDown") {
                    this.anim.play("leftDown");
                    this.v = "leftDown";
                }
            }
            if (!this.collider) {
                this.node.y += Math.sin(this.kz.radian) * dt * 90;
                this.node.x += Math.cos(this.kz.radian) * dt * 90;
            }
        }
    },


    onCollisionStay: function onCollisionStay(other, self) {

        var selfAabb = self.world.aabb;
        var otherAabb = other.world.aabb;

        if (cc.Intersection.rectRect(selfAabb, otherAabb)) {

            if (this.node.x < 0 && selfAabb.xMax > otherAabb.xMax) {
                // console.log("左边碰撞");
                this.node.x = otherAabb.xMax + selfAabb.width / 2;
            } else if (this.node.x > 0 && selfAabb.xMin < otherAabb.xMin) {
                // console.log("右边碰撞");
                this.node.x = otherAabb.xMin - selfAabb.width / 2;
            } else if (this.node.y > 0 && selfAabb.yMin < otherAabb.yMin) {
                //console.log("上边碰撞");
                this.node.y = otherAabb.yMin - selfAabb.height / 2;
            } else if (this.node.y < 0 && selfAabb.yMax > otherAabb.yMax) {
                //console.log("下边碰撞");
                this.node.y = otherAabb.yMax + selfAabb.height / 2;
            }
        }
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=conzhi.js.map
        