"use strict";
cc._RF.push(module, '9cde0Qe5ThJEZUoMxmEYLb1', 'LineMotionStreak');
// LineMotionStreak.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, requireComponent = _a.requireComponent;
/**绘制线段时候，如果与上一个点距离多近，就忽略该点的绘制 */
var MIN_IGNORE_LENGTH = 3;
/**绘制线段时候，如果与上一个点距离多远，就忽略该点的绘制 */
var MAX_IGNORE_LENGTH = 30;
/**
 * 逻辑拖尾组件，使用 cc.Graphics 绘制的拖尾组件
 */
var LineMotionStreak = /** @class */ (function (_super) {
    __extends(LineMotionStreak, _super);
    function LineMotionStreak() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.lineColor = cc.Color.WHITE;
        _this.lineWidth = 10;
        _this.historySize = 20;
        _this.ropeSize = 5;
        _this.historyX = [];
        _this.historyY = [];
        _this.points = [];
        _this.targetNode = null;
        return _this;
    }
    LineMotionStreak.prototype.onLoad = function () {
        this.ctx = this.getComponent(cc.Graphics);
    };
    LineMotionStreak.prototype.onEnable = function () {
        this.initData();
    };
    LineMotionStreak.prototype.initData = function () {
        this.historyX.length = 0;
        this.historyY.length = 0;
        this.points.length = 0;
        var worldPos = this.node.convertToWorldSpaceAR(cc.Vec2.ZERO);
        for (var i = 0; i < this.historySize; i++) {
            this.historyX.push(worldPos.x);
            this.historyY.push(worldPos.y);
        }
        //初始化
        for (var j = 0; j < this.ropeSize; j++) {
            this.points.push(cc.v2());
        }
    };
    LineMotionStreak.prototype.update = function (dt) {
        if (this.targetNode == null) {
            return;
        }
        //记录当前世界坐标
        var worldPos = this.targetNode.convertToWorldSpaceAR(cc.Vec2.ZERO);
        this.historyX.pop();
        this.historyX.unshift(worldPos.x);
        this.historyY.pop();
        this.historyY.unshift(worldPos.y);
        // 更新历史点记录
        for (var k = 0; k < this.ropeSize; k++) {
            var p = this.points[k];
            // 通过 cubicInterpolation 函数让路径曲线更平滑
            var ix = cubicInterpolation(this.historyX, k / this.ropeSize * this.historySize);
            var iy = cubicInterpolation(this.historyY, k / this.ropeSize * this.historySize);
            p.x = ix;
            p.y = iy;
        }
        this.rendererLine();
    };
    LineMotionStreak.prototype.rendererLine = function () {
        this.ctx.clear();
        this.ctx.lineWidth = this.lineWidth;
        this.ctx.lineCap = cc.Graphics.LineCap.ROUND;
        this.ctx.strokeColor = this.lineColor;
        var firstPos = this.targetNode.getParent().convertToNodeSpaceAR(this.points[0]);
        this.ctx.moveTo(firstPos.x, firstPos.y);
        var lastPos = this.points[0];
        for (var i = 1; i < this.points.length; i++) {
            var pos = this.points[i];
            //坐标过于贴近时跳过，防止绘制时出现毛刺
            var mag = pos.sub(lastPos).magSqr();
            if (mag <= MIN_IGNORE_LENGTH * MIN_IGNORE_LENGTH)
                continue;
            var spacePos = this.targetNode.getParent().convertToNodeSpaceAR(pos);
            this.ctx.lineTo(spacePos.x, spacePos.y);
            lastPos = pos;
        }
        this.ctx.stroke();
    };
    __decorate([
        property
    ], LineMotionStreak.prototype, "lineColor", void 0);
    __decorate([
        property({ tooltip: '线的宽度' })
    ], LineMotionStreak.prototype, "lineWidth", void 0);
    __decorate([
        property({ tooltip: '决定拖尾有多长' })
    ], LineMotionStreak.prototype, "historySize", void 0);
    __decorate([
        property({ tooltip: "决定拖尾有多平滑,会影响性能" })
    ], LineMotionStreak.prototype, "ropeSize", void 0);
    __decorate([
        property(cc.Node)
    ], LineMotionStreak.prototype, "targetNode", void 0);
    LineMotionStreak = __decorate([
        ccclass,
        requireComponent(cc.Graphics)
    ], LineMotionStreak);
    return LineMotionStreak;
}(cc.Component));
exports.default = LineMotionStreak;
/**
 * Cubic interpolation based on https://github.com/osuushi/Smooth.js
 */
function clipInput(k, arr) {
    if (k < 0)
        k = 0;
    if (k > arr.length - 1)
        k = arr.length - 1;
    return arr[k];
}
function getTangent(k, factor, array) {
    return factor * (clipInput(k + 1, array) - clipInput(k - 1, array)) / 2;
}
function cubicInterpolation(array, t, tangentFactor) {
    if (tangentFactor === void 0) { tangentFactor = 1; }
    var k = Math.floor(t);
    var m = [getTangent(k, tangentFactor, array), getTangent(k + 1, tangentFactor, array)];
    var p = [clipInput(k, array), clipInput(k + 1, array)];
    t -= k;
    var t2 = t * t;
    var t3 = t * t2;
    return (2 * t3 - 3 * t2 + 1) * p[0] + (t3 - 2 * t2 + t) * m[0] + (-2 * t3 + 3 * t2) * p[1] + (t3 - t2) * m[1];
}

cc._RF.pop();