cc.Class({
    extends: cc.Component,

    properties: {
    },

    // use this for initialization
    onLoad: function () {
        this.drawing_scene = cc.find("Canvas/bg").getComponent("drawing_scene");
        this.color_type;
        this.color;
        this.size;
        this.is_click = false;
        this.first_draw = true;
        this.drawing_state = 1
        this.set_touch_ctrl();
    },

    set_touch_ctrl:function(){
        cc.director.getCollisionManager().enabled=true;
        var self = this;
        let mwidth = self.node.getContentSize().width;
        let mhight = self.node.getContentSize().height;
        let rt = new cc.RenderTexture(mwidth, mhight);
        self.node._sgNode.addChild(rt);
        rt.begin();
        rt.end();
        this.node.parent.on(cc.Node.EventType.TOUCH_START,function(touch,event){
            var touchLoc = touch.getLocation();
            if(1){
                touchLoc = self.node.convertToNodeSpaceAR(touchLoc);
                touchLoc.x += self.node.getContentSize().width / 2;
                touchLoc.y += self.node.getContentSize().height / 2;
                self.originPoint = touchLoc;
                self.is_click=true;
            }
            return true;

        }.bind(this),this.node)
        this.node.parent.on(cc.Node.EventType.TOUCH_MOVE,function(touch,event){
            var touchLoc = touch.getLocation();
            if(1){
                if(self.is_click){
                    touchLoc = self.node.convertToNodeSpaceAR(touchLoc);
                    touchLoc.x += self.node.width / 2;
                    touchLoc.y += self.node.height / 2;
					//涂色
                    if(self.drawing_state==1){
                        let originPoint = self.originPoint;
                        let e1 = new cc.DrawNode();
                        e1.drawSegment(originPoint, touchLoc, 30,cc.hexToColor("b83e08"));
                        rt.begin();
                        e1.visit();
                        rt.end();
                        self.originPoint = touchLoc;
                    }
					//橡皮擦
					else if(self.drawing_state==2){
                        let originPoint = self.originPoint;
                        let e2 = new cc.DrawNode();
                        e2.drawSegment(originPoint, touchLoc, 30,cc.hexToColor("ffffff"));
                        e2.setBlendFunc(771,0);
                        rt.begin();
                        e2.visit();
                        rt.end();
                        self.originPoint = touchLoc;
                    }
                    
                }
            }  
            return true;
        }.bind(this),this.node)
        this.node.parent.on(cc.Node.EventType.TOUCH_END,function(){
            if(self.is_click){
                self.is_click = false;
            }           
        }.bind(this),this.node)
        this.node.parent.on(cc.Node.EventType.TOUCH_CANCEL,function(){
            self.is_click = false;
        }.bind(this),this.node)
    },

    set_drawing_state:function(t,num){
        num = parseInt(num);
        this.drawing_state=num;
    },


    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
});
