/*
 * @Author: jifgao
 * @Date:   2020-08-13 17:19:29
 * @Last Modified by:   jifgao
 * @Last Modified time: 2020-08-14 17:02:26
 */
// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class PhysicsBound extends cc.Component {

    @property(cc.Size)
    size:cc.Size = cc.size(0,0);

    @property(cc.Boolean)
    hasMouseJoint:boolean  = false;


    onLoad () {
        // this.scheduleOnce(function(){
           
        // }.bind(this),1)

        let width:number = this.size.width = this.node.width;
        let height:number = this.size.height = this.node.height;

        this.size = cc.size(width,height);

        // let node:cc.Node = new cc.Node();
        // let body:cc.RigidBody = node.addComponent(cc.RigidBody);
        // body.type = cc.RigidBodyType.Static;
        // this._addBound(node,0,height / 2,width,20);//顶部 缸体厚度 20
        // this._addBound(node,0,height / -2 + 60,width,20);//低部 缸体厚度 20
        // this._addBound(node,width / 2,0,20,height);//右边 缸体厚度 20
        // this._addBound(node,width / -2,0,20,height);//左边 缸体厚度 20
        // node.parent = this.node;

        // if(this.hasMouseJoint){
        //     let joint:cc.MouseJoint = node.addComponent(cc.MouseJoint);
        //     joint.mouseRegion = this.node
        // }
    }

    _addBound(__node:cc.Node,__x:number,__y:number,__width:number,__height:number){
        let collider:cc.PhysicsBoxCollider = __node.addComponent(cc.PhysicsBoxCollider);
        collider.offset.x = __x;
        collider.offset.y = __y;
        collider.size.width = __width;
        collider.size.height = __height;
        collider.restitution = 0.5
    }

    start () {

    }

    // update (dt) {}
}
