/*
 * @Author: jifgao
 * @Date:   2020-08-13 16:06:38
 * @Last Modified by:   jifgao
 * @Last Modified time: 2020-08-22 15:46:17
 */
// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import ListItems,{Item} from "./ListItems";
const {ccclass, property} = cc._decorator;

@ccclass
export default class SceneList extends cc.Component {

    @property(cc.Node)
    content: cc.Node = null;

    @property(cc.Prefab)
    itemTemplate:cc.Prefab = null;

    onLoad () {
        this.initItemList();
        
    }

    initItemList(){
        let listItems:Item [] = ListItems.listItems;
        for (let index = 0; index < listItems.length; index++) {
            const element = listItems[index];
            this._addItem(element,index);
        }
    }

    _addItem(__item:Item,__index:number){
        let node:any = cc.instantiate(this.itemTemplate);
        node.index = __index;
        this.content.addChild(node)
        let label:cc.Label =  node.getChildByName("label").getComponent(cc.Label)
        label.string = __item.desc;
        node.on("click",this._onItemClick,this)
    }

    _onItemClick(__button){
        cc.log(__button.node.index,"click")
        let item = ListItems.listItems[__button.node.index];
        if( typeof (item.name) != "undefined" &&  item.name != ""){
            cc.director.preloadScene(item.name,function(){
                cc.director.loadScene(item.name);
            })
        }

    }

    start () {
        
    }

    // update (dt) {}
}
