/*
 * @Author: jifgao
 * @Date:   2020-08-15 17:35:07
 * @Last Modified by:   jifgao
 * @Last Modified time: 2020-08-17 17:09:57
 */
// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;
import BaseScene from "../BaseScene"
@ccclass
export default class SpineNum extends BaseScene {

    @property(cc.Prefab)
    template: cc.Prefab = null;
    
    @property(cc.Label)
    lbCount: cc.Label = null;

    @property(cc.Button)
    btnAdd: cc.Button = null;

    _contentNode:cc.Node = null;

    

    _count:number = 0;

    onLoad(){
        super.onLoad();
        this.lbCount.getComponent(cc.Label).string = "total:" + this._count;
        this._contentNode = this.node.getChildByName("contentNode")
    }

    start () {

    }

    onGenNodes(){
        let count = 10
        for (let index = 0; index < count; index++) {
             let node:cc.Node = cc.instantiate(this.template);
            node.parent = this._contentNode;
            node.x = (Math.random() - 0.5) * (this.node.width - 200) + 50
            node.y = (Math.random() - 0.5) * (this.node.height - 200) 
            if(node.y > this.node.height / 2 - 130){
                node.y = this.node.height / 2 - 130
            }
            
        }
        this._count += count;
        this.lbCount.getComponent(cc.Label).string = "total:" + this._count;

    }

    // update (dt) {}
}
